/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.Lists;
import com.tristankechlo.livingthings.config.entity.SnailConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class SnailEntity
extends Animal
implements ILexiconEntry {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHELL_COLOR_F = SynchedEntityData.defineId(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHELL_COLOR_B = SynchedEntityData.defineId(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final ResourceLocation[] BODY_TEXTURES = new ResourceLocation[]{SnailEntity.textureLocation("snail_body_1.png")};
    private static final ResourceLocation[] SHELL_TEXTURES_B = new ResourceLocation[]{SnailEntity.textureLocation("snail_shell_b1.png"), SnailEntity.textureLocation("snail_shell_b2.png")};
    private static final ResourceLocation[] SHELL_TEXTURES_F = new ResourceLocation[]{SnailEntity.textureLocation("snail_shell_f1.png"), SnailEntity.textureLocation("snail_shell_f2.png")};

    public SnailEntity(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean checkSnailSpawnRules(EntityType<SnailEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.SNAIL_SPAWNABLE_ON) && SnailEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    private static final ResourceLocation textureLocation(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"livingthings", (String)("textures/entity/snail/" + name));
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        SnailEntity snailChild = (SnailEntity)ModEntityTypes.SNAIL.get().create((Level)world);
        if (entity == this) {
            snailChild.setShellColor(PatternType.FOREGROUND, this.getShellColor(PatternType.FOREGROUND));
            snailChild.setShellColor(PatternType.BACKGROUND, this.getShellColor(PatternType.BACKGROUND));
            snailChild.setVariant(this.getVariant());
            return snailChild;
        }
        RandomSource random = world.getRandom();
        if (entity instanceof SnailEntity) {
            SnailEntity parentSnail = (SnailEntity)entity;
            ArrayList colors = Lists.newArrayList((Object[])new Integer[]{this.getShellColor(PatternType.FOREGROUND), this.getShellColor(PatternType.BACKGROUND), parentSnail.getShellColor(PatternType.FOREGROUND), parentSnail.getShellColor(PatternType.BACKGROUND)});
            snailChild.setShellColor(PatternType.FOREGROUND, (Integer)colors.get(random.nextInt(4)));
            snailChild.setShellColor(PatternType.BACKGROUND, (Integer)colors.get(random.nextInt(4)));
            short bodyVariant = random.nextBoolean() ? this.getBodyVariant() : parentSnail.getBodyVariant();
            short shellVariant = !random.nextBoolean() ? this.getShellVariant() : parentSnail.getShellVariant();
            snailChild.setVariant(bodyVariant, shellVariant);
        } else {
            SnailVariants preset = SnailVariants.random(random);
            snailChild.setShellColor(PatternType.FOREGROUND, preset.getForegroundColor());
            snailChild.setShellColor(PatternType.BACKGROUND, preset.getBackgroundColor());
            snailChild.setVariant(preset.getVariant());
        }
        return snailChild;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, SnailConfig.health()).add(Attributes.MOVEMENT_SPEED, SnailConfig.movementSpeed());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        SnailVariants data = SnailVariants.random(worldIn.getRandom());
        this.setVariant(data.getVariant());
        this.setShellColor(PatternType.FOREGROUND, data.getForegroundColor());
        this.setShellColor(PatternType.BACKGROUND, data.getBackgroundColor());
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredients.SNAIL_FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)SnailVariants.NORMAL.getVariant());
        builder.define(SHELL_COLOR_F, (Object)SnailVariants.NORMAL.getForegroundColor());
        builder.define(SHELL_COLOR_B, (Object)SnailVariants.NORMAL.getBackgroundColor());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getByte("SnailVariant"));
        this.setShellColor(PatternType.FOREGROUND, compound.getInt("ShellColorF"));
        this.setShellColor(PatternType.BACKGROUND, compound.getInt("ShellColorB"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("SnailVariant", this.getVariant());
        compound.putInt("ShellColorF", this.getShellColor(PatternType.FOREGROUND));
        compound.putInt("ShellColorB", this.getShellColor(PatternType.BACKGROUND));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.SNAIL_FOOD);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof DyeItem) {
            DyeColor color = ((DyeItem)stack.getItem()).getDyeColor();
            if (player.isCrouching()) {
                this.setShellColor(PatternType.FOREGROUND, color.getTextureDiffuseColor());
            } else {
                this.setShellColor(PatternType.BACKGROUND, color.getTextureDiffuseColor());
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public ResourceLocation getBodyTexture() {
        return BODY_TEXTURES[this.getBodyVariant()];
    }

    private short getBodyVariant() {
        return (short)(this.getVariant() >> 16);
    }

    public ResourceLocation getShellPatternTexture(PatternType type) {
        return type == PatternType.FOREGROUND ? SHELL_TEXTURES_F[this.getShellVariant()] : SHELL_TEXTURES_B[this.getShellVariant()];
    }

    private short getShellVariant() {
        return (short)this.getVariant();
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public void setVariant(short bodyVariant, short shellVariant) {
        this.setVariant(bodyVariant << 16 | shellVariant & 0xFFFF);
    }

    public int getShellColor(PatternType type) {
        if (type == PatternType.FOREGROUND) {
            return (Integer)this.entityData.get(SHELL_COLOR_F);
        }
        return (Integer)this.entityData.get(SHELL_COLOR_B);
    }

    public void setShellColor(PatternType type, int color) {
        if (type == PatternType.FOREGROUND) {
            this.entityData.set(SHELL_COLOR_F, (Object)color);
        } else if (type == PatternType.BACKGROUND) {
            this.entityData.set(SHELL_COLOR_B, (Object)color);
        }
    }

    public int getMaxSpawnClusterSize() {
        return SnailConfig.maxSpawnedInChunk();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.SNAIL;
    }

    public static enum PatternType {
        FOREGROUND,
        BACKGROUND;

    }

    static enum SnailVariants {
        NORMAL(0, 0, 11693105, 8209952),
        GREEN(0, 0, 412975, 2129982),
        PURPLE(0, 0, 6488099, 10238043),
        BLUE(0, 0, 4857561, 6447075),
        RED(0, 0, 10367513, 13586001),
        NORMAL_2(0, 1, 9847813, 7352576);

        private final int variant;
        private final int colorForeground;
        private final int colorBackground;
        private static final SnailVariants[] VALUES;

        private SnailVariants(int bodyVariant, int shellVariant, int colorb, int colorf) {
            this.variant = bodyVariant << 16 | shellVariant & 0xFFFF;
            this.colorBackground = FastColor.ARGB32.opaque((int)colorb);
            this.colorForeground = FastColor.ARGB32.opaque((int)colorf);
        }

        public int getVariant() {
            return this.variant;
        }

        public int getForegroundColor() {
            return this.colorForeground;
        }

        public int getBackgroundColor() {
            return this.colorBackground;
        }

        public static SnailVariants random(RandomSource rand) {
            return VALUES[rand.nextInt(VALUES.length)];
        }

        static {
            VALUES = SnailVariants.values();
        }
    }
}

