/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.NetherKnightConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;

public class NetherKnightEntity
extends Monster
implements ILexiconEntry {
    public NetherKnightEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, NetherKnightConfig.health()).add(Attributes.MOVEMENT_SPEED, NetherKnightConfig.movementSpeed()).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_DAMAGE, NetherKnightConfig.attackDamage());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, SpawnGroupData data) {
        this.setCanPickUpLoot(false);
        this.setLeftHanded(world.getRandom().nextBoolean());
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        return super.finalizeSpawn(world, difficultyInstance, spawnReason, data);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance $$1) {
        EquipmentSlot first = random.nextBoolean() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        EquipmentSlot second = first == EquipmentSlot.MAINHAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
        this.setItemSlot(first, this.createMainHandItem(random));
        this.setItemSlot(second, this.createOffHandItem(random));
    }

    protected void dropEquipment() {
        ItemStack offHand;
        double dropChance = NetherKnightConfig.weaponDropChance() / 100.0;
        ItemStack mainHand = this.getMainHandItem();
        if (mainHand != null && this.random.nextDouble() < dropChance) {
            mainHand.setDamageValue(500 + this.random.nextInt(500));
            this.spawnAtLocation(mainHand);
        }
        if ((offHand = this.getOffhandItem()) != null && this.random.nextDouble() < dropChance) {
            offHand.setDamageValue(500 + this.random.nextInt(500));
            this.spawnAtLocation(offHand);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.2, false, NetherKnightConfig::canAttack));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{NetherKnightEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    private ItemStack createMainHandItem(RandomSource random) {
        ItemStack stack = new ItemStack((ItemLike)Items.NETHERITE_SWORD);
        ImmutableList<String> names = NetherKnightConfig.get().swordNames.get();
        String name = (String)names.get(random.nextInt(names.size()));
        Registry registry = (Registry)this.registryAccess().registry(Registries.ENCHANTMENT).orElseThrow();
        if (random.nextInt(1000) == 0) {
            name = "Buecher_wurm's Butter Knife";
            stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.SHARPNESS), 4 + random.nextInt(6));
            stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.FIRE_ASPECT), 1 + random.nextInt(2));
            stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.KNOCKBACK), 1 + random.nextInt(2));
            stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.UNBREAKING), 1 + random.nextInt(3));
        } else {
            stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.SHARPNESS), 2 + random.nextInt(3));
        }
        stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.LOOTING), 1);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
        return stack;
    }

    private ItemStack createOffHandItem(RandomSource random) {
        ItemStack stack = new ItemStack((ItemLike)Items.NETHERITE_AXE);
        ImmutableList<String> names = NetherKnightConfig.get().axeNames.get();
        String name = (String)names.get(random.nextInt(names.size()));
        Registry registry = (Registry)this.registryAccess().registry(Registries.ENCHANTMENT).orElseThrow();
        if (random.nextInt(1000) == 0) {
            name = "Buecher_wurm's War Axe";
            stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.MENDING), 1);
            stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.EFFICIENCY), 3 + random.nextInt(3));
        } else {
            stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.EFFICIENCY), 1 + random.nextInt(3));
        }
        stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.SHARPNESS), 2);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
        return stack;
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.NETHER_KNIGHT_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.NETHER_KNIGHT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.NETHER_KNIGHT_DEATH.get();
    }

    protected void playStepSound(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.playSound(ModSounds.NETHER_KNIGHT_STEP.get(), 0.15f, 1.0f);
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    public boolean canStandOnFluid(FluidState fluid) {
        return fluid.is(FluidTags.LAVA);
    }

    public boolean isOnFire() {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.isInLava()) {
            CollisionContext iselectioncontext = CollisionContext.of((Entity)this);
            if (iselectioncontext.isAbove(LiquidBlock.STABLE_SHAPE, this.blockPosition(), true) && !this.level().getFluidState(this.blockPosition().above()).is(FluidTags.LAVA)) {
                this.setOnGround(true);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            }
        }
    }

    protected void checkFallDamage(double p_184231_1_, boolean p_184231_3_, BlockState state, BlockPos pos) {
        if (this.isInLava()) {
            this.fallDistance = 0.0f;
        } else {
            super.checkFallDamage(p_184231_1_, p_184231_3_, state, pos);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (!super.doHurtTarget(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.WITHER, 100));
        }
        return true;
    }

    public boolean hurt(DamageSource source, float damage) {
        return super.hurt(source, damage);
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return effect.getEffect() == MobEffects.WITHER ? false : super.canBeAffected(effect);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.NETHER_KNIGHT;
    }
}

