/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.MantarayConfig;
import com.tristankechlo.livingthings.entity.SharkEntity;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.entity.misc.IScaleableMob;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;

public class MantarayEntity
extends AbstractSchoolingFish
implements IMobVariants,
IScaleableMob,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> MANTARAY_VARIANT = SynchedEntityData.defineId(MantarayEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> MANTARAY_SCALING = SynchedEntityData.defineId(MantarayEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public MantarayEntity(EntityType<? extends MantarayEntity> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, MantarayConfig.health()).add(Attributes.MOVEMENT_SPEED, MantarayConfig.movementSpeed());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.55));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, SharkEntity.class, 16.0f, 1.3, 1.45));
        this.goalSelector.addGoal(3, (Goal)new FollowFlockLeaderGoal((AbstractSchoolingFish)this));
        this.goalSelector.addGoal(4, (Goal)new SwimGoal(this));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MANTARAY_VARIANT, (Object)0);
        builder.define(MANTARAY_SCALING, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("MantarayVariant", this.getVariant());
        compound.putByte("MantarayScaling", this.getScaling());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getByte("MantarayVariant"));
        this.setScaling(compound.getByte("MantarayScaling"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        int colorBlueVariant = (Integer)MantarayConfig.get().colorBlueVariant.get();
        int colorBrownVariant = (Integer)MantarayConfig.get().colorBrownVariant.get();
        byte variant = this.getRandomVariant(this.random, new byte[]{0, 1}, new int[]{colorBlueVariant, colorBrownVariant});
        this.setVariant(variant);
        this.setScaling(MantarayEntity.getWeightedRandomScaling(this.random));
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public static byte getWeightedRandomScaling(RandomSource random) {
        int scaling1Weight = (Integer)MantarayConfig.get().scalingSmallVariant.get();
        int scaling2Weight = (Integer)MantarayConfig.get().scalingNormalWeight.get();
        int scaling3Weight = (Integer)MantarayConfig.get().scalingLargeVariant.get();
        int scaling4Weight = (Integer)MantarayConfig.get().scalingExtraLargeWeight.get();
        if (scaling1Weight <= 0 && scaling2Weight <= 0 && scaling3Weight <= 0 && scaling4Weight <= 0) {
            return 0;
        }
        Optional scaling = WeightedRandom.getRandomItem((RandomSource)random, (List)ImmutableList.of((Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling1Weight), -2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling2Weight), 0), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling3Weight), 2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling4Weight), 6)));
        return ((IScaleableMob.WeightedMobScaling)scaling.get()).scaling;
    }

    public static boolean checkMantaraySpawnRules(EntityType<MantarayEntity> entity, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getFluidState(pos).is(LivingThingsTags.MANTARAY_SPAWNABLE_ON) && world.getFluidState(pos.above()).is(LivingThingsTags.MANTARAY_SPAWNABLE_ON);
    }

    public boolean canBeLeashed() {
        return true;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.hasCustomName();
    }

    public int getMaxSpawnClusterSize() {
        return MantarayConfig.maxSpawnedInChunk();
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    @Override
    public byte getVariant() {
        return (Byte)this.entityData.get(MANTARAY_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.entityData.set(MANTARAY_VARIANT, (Object)variant);
    }

    @Override
    public byte getScaling() {
        return (Byte)this.entityData.get(MANTARAY_SCALING);
    }

    @Override
    public void setScaling(byte scaling) {
        this.entityData.set(MANTARAY_SCALING, (Object)scaling);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)Items.BUCKET);
    }

    protected SoundEvent getFlopSound() {
        return ModSounds.MANTARAY_FLOP.get();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.MANTARAY;
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final MantarayEntity fish;

        public SwimGoal(MantarayEntity fish) {
            super((PathfinderMob)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean canUse() {
            return this.fish.canRandomSwim() && super.canUse();
        }
    }
}

