/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class PartDataProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"integrateddynamicscompat", (String)"part");

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (config.get(ID)) {
            tooltip.addAll((List)NBTClassType.getClassType(List.class).readPersistedField("tooltip", accessor.getServerData(), (HolderLookup.Provider)accessor.getLevel().registryAccess()));
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        PartHelpers.getPartContainer((ILevelExtension)accessor.getLevel(), blockEntity.getBlockPos(), null).ifPresent(partContainer -> {
            Direction side = partContainer.getWatchingSide(accessor.getLevel(), blockEntity.getBlockPos(), accessor.getPlayer());
            if (side != null && partContainer.hasPart(side)) {
                IPartType partType = partContainer.getPart(side);
                IPartState partState = partContainer.getPartState(side);
                ArrayList tooltip = Lists.newArrayList();
                tooltip.add(Component.translatable((String)partType.getTranslationKey()));
                partType.loadTooltip(partState, (List<Component>)tooltip);
                NBTClassType.getClassType(List.class).writePersistedField("tooltip", (Object)tooltip, tag, (HolderLookup.Provider)accessor.getLevel().registryAccess());
            }
        });
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

