/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.IDynamicModelElementCommon;
import org.cyclops.cyclopscore.config.extendedconfig.BlockClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.client.model.CableModel;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class BlockCableClientConfig
extends BlockClientConfig<IntegratedDynamics> {
    public static TextureAtlasSprite BLOCK_TEXTURE;

    public BlockCableClientConfig(BlockConfigCommon<IntegratedDynamics> blockConfig) {
        super(blockConfig);
        ((IntegratedDynamics)blockConfig.getMod()).getModEventBus().addListener(this::onRegisterColors);
        ((IntegratedDynamics)blockConfig.getMod()).getModEventBus().addListener(this::registerClientExtensions);
        ((IntegratedDynamics)blockConfig.getMod()).getModEventBus().addListener(this::postTextureStitch);
    }

    public void onRegisterColors(RegisterColorHandlersEvent.Block event) {
        event.register((net.minecraft.client.color.block.BlockColor)new BlockColor(), new Block[]{(Block)this.getBlockConfig().getInstance()});
    }

    public void postTextureStitch(TextureAtlasStitchedEvent event) {
        if (event.getAtlas().location().equals((Object)InventoryMenu.BLOCK_ATLAS)) {
            BLOCK_TEXTURE = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"block/cable"));
        }
    }

    public void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerBlock(new IClientBlockExtensions(this){

            public boolean addHitEffects(BlockState blockState, Level world, HitResult target, ParticleEngine particleManager) {
                BlockPos blockPos = ((BlockHitResult)target).getBlockPos();
                if (CableHelpers.hasFacade((ILevelExtension)world, blockPos)) {
                    CableHelpers.getFacade((ILevelExtension)world, blockPos).ifPresent(facadeState -> RenderHelpers.addBlockHitEffects((ParticleEngine)particleManager, (ClientLevel)((ClientLevel)world), (BlockState)facadeState, (BlockPos)blockPos, (Direction)((BlockHitResult)target).getDirection()));
                    return true;
                }
                return false;
            }
        }, new Block[]{(Block)this.getBlockConfig().getInstance()});
    }

    @Nullable
    public IDynamicModelElementCommon getDynamicModelElement() {
        return new DynamicModel();
    }

    public static class BlockColor
    implements net.minecraft.client.color.block.BlockColor {
        public int getColor(BlockState blockState, @Nullable BlockAndTintGetter world, @Nullable BlockPos blockPos, int color) {
            return blockPos == null ? -1 : CableHelpers.getFacadeMultipartTicking((BlockGetter)world, blockPos).map(facadeState -> Minecraft.getInstance().getBlockColors().getColor(facadeState, world, blockPos, color)).orElse(-1);
        }
    }

    public static class DynamicModel
    implements IDynamicModelElementCommon {
        public BakedModel createDynamicModel(Consumer<Pair<ModelResourceLocation, BakedModel>> modelConsumer) {
            CableModel model = new CableModel();
            ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey((Object)((Block)RegistryEntries.BLOCK_CABLE.get()));
            modelConsumer.accept((Pair<ModelResourceLocation, BakedModel>)Pair.of((Object)new ModelResourceLocation(registryName, "waterlogged=false"), (Object)((Object)model)));
            modelConsumer.accept((Pair<ModelResourceLocation, BakedModel>)Pair.of((Object)new ModelResourceLocation(registryName, "waterlogged=true"), (Object)((Object)model)));
            modelConsumer.accept((Pair<ModelResourceLocation, BakedModel>)Pair.of((Object)new ModelResourceLocation(registryName, "inventory"), (Object)((Object)model)));
            return model;
        }
    }
}

