/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_simple_generator;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import dev.hail.create_simple_generator.Config;
import dev.hail.create_simple_generator.StressGeneratorBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;

public class StressGeneratorEntity
extends KineticBlockEntity {
    private final EnergyStorage energyStorage = new EnergyStorage(0);
    protected List<Entity> caughtEntities = new ArrayList<Entity>();

    public StressGeneratorEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        boolean justExtracted;
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        Direction face = (Direction)this.getBlockState().getValue((Property)StressGeneratorBlock.FACING);
        IEnergyStorage energyStorage = null;
        Container itemStorage = null;
        IItemHandler itemHandler = null;
        if (this.level != null) {
            energyStorage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.getBlockPos().relative(face), (Object)face.getOpposite());
            itemStorage = HopperBlockEntity.getContainerAt((Level)this.level, (BlockPos)this.getBlockPos().relative(face));
            itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.getBlockPos().relative(face), (Object)face.getOpposite());
        }
        if (justExtracted = this.extractPowerTo(energyStorage)) {
            return;
        }
        if (itemStorage != null && Config.canChargeItemInBlock && this.forItemInStorage(itemStorage)) {
            return;
        }
        if (itemHandler != null && Config.canChargeItemInBlock && this.forItemInStorage(itemHandler)) {
            return;
        }
        if (Config.canChargeItemEntity || Config.canChargeItemInEntity) {
            this.caughtEntities.clear();
            this.caughtEntities = Objects.requireNonNull(this.getLevel()).getEntities(null, new AABB(this.getBlockPos().relative(face)).expandTowards(Vec3.atLowerCornerOf((Vec3i)face.getNormal()).scale(0.0)));
            for (Entity entity : this.caughtEntities) {
                Player player;
                if (entity instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entity;
                    if (Config.canChargeItemEntity && (justExtracted = this.extractPowerTo(energyStorage = (IEnergyStorage)itemEntity.getItem().getCapability(Capabilities.EnergyStorage.ITEM)))) {
                        return;
                    }
                }
                if (!Config.canChargeItemInEntity) continue;
                if (entity instanceof Player && this.forItemInStorage(itemStorage = (player = (Player)entity).getInventory())) {
                    return;
                }
                itemHandler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY);
                if (itemHandler == null || !this.forItemInStorage(itemHandler)) continue;
                return;
            }
        }
    }

    public boolean forItemInStorage(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            IEnergyStorage energyStorage = (IEnergyStorage)itemHandler.getStackInSlot(i).getCapability(Capabilities.EnergyStorage.ITEM);
            boolean justExtracted = this.extractPowerTo(energyStorage);
            if (!justExtracted) continue;
            return true;
        }
        return false;
    }

    public boolean forItemInStorage(Container itemStorage) {
        for (int i = 0; i < itemStorage.getContainerSize(); ++i) {
            IEnergyStorage energyStorage = (IEnergyStorage)itemStorage.getItem(i).getCapability(Capabilities.EnergyStorage.ITEM);
            boolean justExtracted = this.extractPowerTo(energyStorage);
            if (!justExtracted) continue;
            return true;
        }
        return false;
    }

    public boolean extractPowerTo(IEnergyStorage energyStorage) {
        if (energyStorage != null && (energyStorage.getEnergyStored() < energyStorage.getMaxEnergyStored() || energyStorage.getMaxEnergyStored() == 0)) {
            energyStorage.receiveEnergy((int)Math.abs((double)this.getSpeed() * Config.generatorGeneratesEnergyMultiplier), false);
            return true;
        }
        return false;
    }

    public EnergyStorage getEnergyStored() {
        return this.energyStorage;
    }
}

