/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_simple_generator;

import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.foundation.block.IBE;
import dev.hail.create_simple_generator.CSGContents;
import dev.hail.create_simple_generator.StressGeneratorEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
public class StressGeneratorBlock
extends DirectionalKineticBlock
implements IBE<StressGeneratorEntity> {
    public StressGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockState placedOn = world.getBlockState(pos.relative(face.getOpposite()));
        BlockState placedOnOpposite = world.getBlockState(pos.relative(face));
        if (AbstractChuteBlock.isChute((BlockState)placedOn)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face.getOpposite());
        }
        if (AbstractChuteBlock.isChute((BlockState)placedOnOpposite)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face);
        }
        Direction preferredFacing = this.getPreferredFacing(context);
        if (preferredFacing == null) {
            preferredFacing = context.getNearestLookingDirection();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? preferredFacing : preferredFacing.getOpposite()));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    public Class<StressGeneratorEntity> getBlockEntityClass() {
        return StressGeneratorEntity.class;
    }

    public BlockEntityType<? extends StressGeneratorEntity> getBlockEntityType() {
        return (BlockEntityType)CSGContents.STRESS_GENERATOR_ENTITY.get();
    }
}

