/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.network;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.util.Utils;

public record SyncAffixSettingPacket(Map<ResourceLocation, AffixSetting> affixSettingMap) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, SyncAffixSettingPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.fromCodec((Codec)ResourceLocation.CODEC), (StreamCodec)ByteBufCodecs.fromCodec(AffixSetting.CODEC)), SyncAffixSettingPacket::affixSettingMap, SyncAffixSettingPacket::new);
    public static final CustomPacketPayload.Type<SyncAffixSettingPacket> TYPE = new CustomPacketPayload.Type(Utils.getLocation("sync_affix_setting"));

    public static void handle(SyncAffixSettingPacket data, IPayloadContext cxt) {
        cxt.enqueueWork(() -> {
            if (cxt.flow().isClientbound()) {
                Champions.API.getAffixDataLoader().cache(data.affixSettingMap);
            }
        });
        cxt.enqueueWork(SyncAffixSettingPacket::handelSettingMainThread);
    }

    public static void handelSettingMainThread() {
        Champions.API.getAffixDataLoader().getLoadedData().forEach((resourceLocation, affixSetting) -> Champions.API.getAffix(affixSetting.type()).ifPresent(affix -> {
            affix.applySetting((AffixSetting)affixSetting);
            Champions.API.addCategory(affix.getCategory(), (IAffix)affix);
        }));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

