/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.network;

import com.mojang.serialization.Codec;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffixBase;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.util.Utils;

public record SPacketSyncChampion(int entityId, int tier, String defaultColor, Set<ResourceLocation> affixes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SPacketSyncChampion> TYPE = new CustomPacketPayload.Type(Utils.getLocation("sync_champion"));
    public static final StreamCodec<FriendlyByteBuf, SPacketSyncChampion> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SPacketSyncChampion::entityId, (StreamCodec)ByteBufCodecs.INT, SPacketSyncChampion::tier, (StreamCodec)ByteBufCodecs.STRING_UTF8, SPacketSyncChampion::defaultColor, (StreamCodec)ByteBufCodecs.fromCodec((Codec)NeoForgeExtraCodecs.setOf((Codec)ResourceLocation.CODEC)), SPacketSyncChampion::affixes, SPacketSyncChampion::new);

    public static void handle(SPacketSyncChampion data, IPayloadContext cxt) {
        cxt.enqueueWork(() -> {
            if (cxt.flow().isClientbound()) {
                Level level = cxt.player().level();
                Entity entity = level.getEntity(data.entityId);
                assert (entity != null);
                ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                    IChampion.Client clientChampion = champion.getClient();
                    clientChampion.setRank((Tuple<Integer, String>)new Tuple((Object)data.tier, (Object)data.defaultColor));
                    clientChampion.setAffixes(data.affixes);
                });
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void syncChampionDataToPlayerTrackingEntity(IChampion.Server championData, LivingEntity targetEntity) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)targetEntity, (CustomPacketPayload)new SPacketSyncChampion(targetEntity.getId(), championData.getRank().map(Rank::getTier).orElse(0), championData.getRank().map(Rank::getDefaultColor).orElse(TextColor.fromRgb((int)0)).toString(), championData.getAffixes().stream().map(IAffixBase::getIdentifier).collect(Collectors.toSet())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

