/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.common.registry.AffixTypes;
import top.theillusivec4.champions.common.registry.ModDamageTypes;
import top.theillusivec4.champions.common.registry.ModEntityTypes;
import top.theillusivec4.champions.common.registry.ModItems;
import top.theillusivec4.champions.common.registry.ModMobEffects;

public class ModLanguageProvider
extends LanguageProvider {
    private final String locale;

    public ModLanguageProvider(PackOutput output, String locale) {
        this(output, "champions", locale);
    }

    public ModLanguageProvider(PackOutput output) {
        this(output, "en_us");
    }

    public ModLanguageProvider(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
        this.locale = locale;
    }

    protected void addTranslations() {
        switch (this.locale) {
            case "zh_cn": {
                this.addChineseTranslations();
                break;
            }
            case "ko_kr": {
                this.addKoreaTranslations();
                break;
            }
            case "ru_ru": {
                this.addRussianTranslations();
                break;
            }
            case "tr_tr": {
                this.addTurkishTranslations();
                break;
            }
            case "uk_ua": {
                this.addUkrainianTranslations();
                break;
            }
            case "pt_br": {
                this.addBrazilianPortugueseTranslations();
                break;
            }
            default: {
                this.addEnglishTranslations();
            }
        }
    }

    private void addBrazilianPortugueseTranslations() {
        this.addAffix((IAffix)AffixTypes.ADAPTABLE.get(), "Adapt\u00e1vel");
        this.addAffix((IAffix)AffixTypes.ARCTIC.get(), "\u00c1rtico");
        this.addAffix((IAffix)AffixTypes.DAMPENING.get(), "Amortecedor");
        this.addAffix((IAffix)AffixTypes.DESECRATING.get(), "Profanador");
        this.addAffix((IAffix)AffixTypes.ENKINDLING.get(), "Incendi\u00e1rio");
        this.addAffix((IAffix)AffixTypes.HASTY.get(), "Apresado");
        this.addAffix((IAffix)AffixTypes.INFESTED.get(), "Infestado");
        this.addAffix((IAffix)AffixTypes.KNOCKING.get(), "Empurrador");
        this.addAffix((IAffix)AffixTypes.LIVELY.get(), "Vigoroso");
        this.addAffix((IAffix)AffixTypes.MAGNETIC.get(), "Magn\u00e9tico");
        this.addAffix((IAffix)AffixTypes.MOLTEN.get(), "Fundido");
        this.addAffix((IAffix)AffixTypes.PARALYZING.get(), "Paralisante");
        this.addAffix((IAffix)AffixTypes.PLAGUED.get(), "Pestilento");
        this.addAffix((IAffix)AffixTypes.REFLECTIVE.get(), "Reflexivo");
        this.addAffix((IAffix)AffixTypes.SHIELDING.get(), "Protetor");
        this.addAffix((IAffix)AffixTypes.WOUNDING.get(), "Dilacerante");
        this.addRank(1, "Comum");
        this.addRank(2, "Habilidoso");
        this.addRank(3, "Elite");
        this.addRank(4, "Lend\u00e1rio");
        this.addRank(5, "Supremo");
        this.add((Item)ModItems.CHAMPION_EGG_ITEM.get(), "Ovo de Campe\u00e3o");
        this.add("item.champions.egg.tooltip", "Afixos Aleat\u00f3rios");
        this.add((EntityType)ModEntityTypes.ENKINDLING_BULLET.get(), "Proj\u00e9til Incendi\u00e1rio");
        this.add((EntityType)ModEntityTypes.ARCTIC_BULLET.get(), "Proj\u00e9til \u00c1rtico");
        this.add((MobEffect)ModMobEffects.PARALYSIS_EFFECT_TYPE.get(), "Paralisia");
        this.add((MobEffect)ModMobEffects.WOUND_EFFECT_TYPE.get(), "Ferimento");
        this.addDamageType(ModDamageTypes.ENKINDLING_BULLET, "%1$s foi atingido por chamas", "%1$s foi atingido por chamas enquanto lutava contra %2$s");
        this.addDamageType(ModDamageTypes.REFLECTION_DAMAGE, "%1$s provou do pr\u00f3prio veneno", "");
        this.add("argument.champions.affix.unknown", "Afixo desconhecido %s");
        this.add("commands.champions.summon.success", "Invocado novo %s");
        this.add("commands.champions.egg.success", "Criado novo %s");
        this.add("command.champions.egg.unknown_entity", "Entidade desconhecida");
        this.add("config.jade.plugin_champions.enable_affix_compact", "Ativar visualiza\u00e7\u00e3o compacta de afixos no Jade");
        this.add("advancements.champions.kill_a_champion.title", "Ca\u00e7ador de Campe\u00f5es");
        this.add("advancements.champions.kill_a_champion.description", "Mate um monstro hostil poderoso");
        this.add("stat.champions.champion_mobs_killed", "Campe\u00f5es Derrotados");
    }

    private void addUkrainianTranslations() {
        this.addAffix((IAffix)AffixTypes.ADAPTABLE.get(), "\u0410\u0434\u0430\u043f\u0442\u043e\u0432\u0430\u043d\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.ARCTIC.get(), "\u0410\u0440\u043a\u0442\u0438\u043a\u0430");
        this.addAffix((IAffix)AffixTypes.DAMPENING.get(), "\u0417\u0432\u043e\u043b\u043e\u0436\u0435\u043d\u043d\u044f");
        this.addAffix((IAffix)AffixTypes.DESECRATING.get(), "Desecrating");
        this.addAffix((IAffix)AffixTypes.ENKINDLING.get(), "\u041e\u0441\u043a\u0432\u0435\u0440\u043d\u0435\u043d\u043d\u044f");
        this.addAffix((IAffix)AffixTypes.HASTY.get(), "\u041f\u043e\u0441\u043f\u0456\u0448\u043d\u043e");
        this.addAffix((IAffix)AffixTypes.INFESTED.get(), "\u0417\u0430\u0440\u0430\u0436\u0435\u043d\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.KNOCKING.get(), "\u0421\u0442\u0443\u043a\u0456\u0442");
        this.addAffix((IAffix)AffixTypes.LIVELY.get(), "\u0416\u0432\u0430\u0432\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.MAGNETIC.get(), "\u041c\u0430\u0433\u043d\u0456\u0442\u043d\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.MOLTEN.get(), "\u0420\u043e\u0437\u043f\u043b\u0430\u0432\u043b\u0435\u043d\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.PARALYZING.get(), "\u041f\u0430\u0440\u0430\u043b\u0456\u0437\u0443\u044e\u0447\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.PLAGUED.get(), "\u0417\u0430\u0440\u0430\u0436\u0435\u043d\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.REFLECTIVE.get(), "\u0421\u0432\u0456\u0442\u043b\u043e\u0432\u0456\u0434\u0431\u0438\u0432\u0430\u044e\u0447\u0456");
        this.addAffix((IAffix)AffixTypes.SHIELDING.get(), "\u0415\u043a\u0440\u0430\u043d\u0456\u0437\u0430\u0446\u0456\u044f");
        this.addAffix((IAffix)AffixTypes.WOUNDING.get(), "\u041f\u043e\u0440\u0430\u043d\u0435\u043d\u043d\u0438\u0439");
        this.addRank(1, "\u0417\u0432\u0438\u0447\u0430\u0439\u043d\u0438\u0439");
        this.addRank(2, "\u041a\u0432\u0430\u043b\u0456\u0444\u0456\u043a\u043e\u0432\u0430\u043d\u0438\u0439");
        this.addRank(3, "\u0415\u043b\u0456\u0442\u0430");
        this.addRank(4, "\u041b\u0435\u0433\u0435\u043d\u0434\u0430\u0440\u043d\u0438\u0439");
        this.addRank(5, "\u041a\u0456\u043d\u0446\u0435\u0432\u0438\u0439");
        this.add((Item)ModItems.CHAMPION_EGG_ITEM.get(), "\u0427\u0435\u043c\u043f\u0456\u043e\u043d\u0441\u044c\u043a\u0435 \u044f\u0439\u0446\u0435");
        this.add("item.champions.egg.tooltip", "\u0412\u0438\u043f\u0430\u0434\u043a\u043e\u0432\u0456 \u0430\u0444\u0456\u043a\u0441\u0438");
        this.add((EntityType)ModEntityTypes.ENKINDLING_BULLET.get(), "Enkindling bullet");
        this.add((EntityType)ModEntityTypes.ARCTIC_BULLET.get(), "Arctic bullet");
        this.add((MobEffect)ModMobEffects.PARALYSIS_EFFECT_TYPE.get(), "\u041f\u0430\u0440\u0430\u043b\u0456\u0447");
        this.add((MobEffect)ModMobEffects.WOUND_EFFECT_TYPE.get(), "\u041f\u043e\u0440\u0430\u043d\u0435\u043d\u043d\u044f");
        this.addDamageType(ModDamageTypes.ENKINDLING_BULLET, "%1$s \u0431\u0443\u0432 \u043e\u0445\u043e\u043f\u043b\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u0443\u043c'\u044f\u043c", "%1$s \u0431\u0443\u0432 \u043e\u0445\u043e\u043f\u043b\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u0443\u043c'\u044f\u043c \u043f\u0456\u0434 \u0447\u0430\u0441 \u0431\u043e\u044e %2$s");
        this.addDamageType(ModDamageTypes.REFLECTION_DAMAGE, "%1$s \u0432\u0456\u0434\u0447\u0443\u043b\u0438 \u0441\u043c\u0430\u043a \u0432\u043b\u0430\u0441\u043d\u0438\u0445 \u043b\u0456\u043a\u0456\u0432", "");
        this.add("argument.champions.affix.unknown", "\u041d\u0435\u0432\u0456\u0434\u043e\u043c\u0438\u0439 \u0430\u0444\u0456\u043a\u0441 %s");
        this.add("commands.champions.summon.success", "\u0412\u0438\u043a\u043b\u0438\u043a\u0430\u0454\u0442\u044c\u0441\u044f \u043d\u043e\u0432\u0438\u0439 %s");
        this.add("commands.champions.egg.success", "\u0421\u0442\u0432\u043e\u0440\u0435\u043d\u043e \u043d\u043e\u0432\u0438\u0439 %s");
        this.add("command.champions.egg.unknown_entity", "\u041d\u0435\u0432\u0456\u0434\u043e\u043c\u0438\u0439 \u0441\u0443\u0431'\u0454\u043a\u0442");
        this.add("config.jade.plugin_champions.enable_affix_compact", "Enable Jade affix compact");
        this.add("advancements.champions.kill_a_champion.title", "\u0427\u0435\u043c\u043f\u0456\u043e\u043d\u0441\u044c\u043a\u0438\u0439 \u043c\u0438\u0441\u043b\u0438\u0432\u0435\u0446\u044c");
        this.add("advancements.champions.kill_a_champion.description", "\u0423\u0431\u0438\u0439\u0442\u0435 \u043f\u043e\u0442\u0443\u0436\u043d\u043e\u0433\u043e \u0432\u043e\u0440\u043e\u0436\u043e\u0433\u043e \u043c\u043e\u043d\u0441\u0442\u0440\u0430");
        this.add("stat.champions.champion_mobs_killed", "\u0427\u0435\u043c\u043f\u0456\u043e\u043d\u0441\u044c\u043a\u0456 \u043d\u0430\u0442\u043e\u0432\u043f\u0438 \u0432\u0431\u0438\u0442\u043e");
    }

    protected void addChineseTranslations() {
        this.addAffix((IAffix)AffixTypes.ADAPTABLE.get(), "\u9002\u5e94");
        this.addAffix((IAffix)AffixTypes.ARCTIC.get(), "\u6781\u5bd2");
        this.addAffix((IAffix)AffixTypes.DAMPENING.get(), "\u6291\u5236");
        this.addAffix((IAffix)AffixTypes.DESECRATING.get(), "\u4eb5\u6e0e");
        this.addAffix((IAffix)AffixTypes.ENKINDLING.get(), "\u70b9\u71c3");
        this.addAffix((IAffix)AffixTypes.HASTY.get(), "\u6025\u901f");
        this.addAffix((IAffix)AffixTypes.INFESTED.get(), "\u611f\u67d3");
        this.addAffix((IAffix)AffixTypes.KNOCKING.get(), "\u7206\u9707");
        this.addAffix((IAffix)AffixTypes.LIVELY.get(), "\u6d3b\u529b");
        this.addAffix((IAffix)AffixTypes.MAGNETIC.get(), "\u78c1\u529b");
        this.addAffix((IAffix)AffixTypes.MOLTEN.get(), "\u7194\u878d");
        this.addAffix((IAffix)AffixTypes.PARALYZING.get(), "\u762b\u75ea");
        this.addAffix((IAffix)AffixTypes.PLAGUED.get(), "\u761f\u75ab");
        this.addAffix((IAffix)AffixTypes.REFLECTIVE.get(), "\u53cd\u5c04");
        this.addAffix((IAffix)AffixTypes.SHIELDING.get(), "\u4fdd\u62a4");
        this.addAffix((IAffix)AffixTypes.WOUNDING.get(), "\u521b\u4f24");
        this.addRank(1, "\u666e\u901a");
        this.addRank(2, "\u7a00\u6709");
        this.addRank(3, "\u7cbe\u82f1");
        this.addRank(4, "\u4f20\u5947");
        this.addRank(5, "\u7ec8\u6781");
        this.add((Item)ModItems.CHAMPION_EGG_ITEM.get(), "\u5f3a\u654c\u86cb");
        this.add("item.champions.egg.tooltip", "\u968f\u673a\u8bcd\u7f00");
        this.add((EntityType)ModEntityTypes.ENKINDLING_BULLET.get(), "\u706b\u7130\u5f39");
        this.add((EntityType)ModEntityTypes.ARCTIC_BULLET.get(), "\u5bd2\u51b0\u5f39");
        this.add((MobEffect)ModMobEffects.PARALYSIS_EFFECT_TYPE.get(), "\u9ebb\u75f9");
        this.add((MobEffect)ModMobEffects.WOUND_EFFECT_TYPE.get(), "\u521b\u4f24");
        this.addDamageType(ModDamageTypes.ENKINDLING_BULLET, "%1$s\u88ab\u706b\u7130\u51fb\u4e2d", "%1$s\u5728\u4e0e%2$s\u7684\u6218\u6597\u4e2d\u88ab\u706b\u7130\u51fb\u4e2d");
        this.addDamageType(ModDamageTypes.REFLECTION_DAMAGE, "%1$s\u906d\u62a5\u5e94\u4e86!", "");
        this.add("argument.champions.affix.unknown", "\u672a\u77e5\u8bcd\u7f00 %s");
        this.add("commands.champions.summon.success", "\u53ec\u5524\u5b9e\u4f53 %s");
        this.add("commands.champions.egg.success", "\u521b\u5efa\u5b9e\u4f53 %s");
        this.add("command.champions.egg.unknown_entity", "\u672a\u77e5\u751f\u7269");
        this.add("config.jade.plugin_champions.enable_affix_compact", "\u542f\u7528jade\u8bcd\u6761\u517c\u5bb9");
        this.add("advancements.champions.kill_a_champion.title", "\u51a0\u519b\u730e\u4eba");
        this.add("advancements.champions.kill_a_champion.description", "\u51fb\u6740\u4e00\u4e2a\u5f3a\u5927\u7684\u654c\u5bf9\u602a\u7269");
        this.add("stat.champions.champion_mobs_killed", "\u51a0\u519b\u602a\u7269\u51fb\u6740\u6570");
    }

    protected void addEnglishTranslations() {
        this.addAffix((IAffix)AffixTypes.ADAPTABLE.get(), "Adaptable");
        this.addAffix((IAffix)AffixTypes.ARCTIC.get(), "Arctic");
        this.addAffix((IAffix)AffixTypes.DAMPENING.get(), "Dampening");
        this.addAffix((IAffix)AffixTypes.DESECRATING.get(), "Desecrating");
        this.addAffix((IAffix)AffixTypes.ENKINDLING.get(), "Enkindling");
        this.addAffix((IAffix)AffixTypes.HASTY.get(), "Hasty");
        this.addAffix((IAffix)AffixTypes.INFESTED.get(), "Infested");
        this.addAffix((IAffix)AffixTypes.KNOCKING.get(), "Knocking");
        this.addAffix((IAffix)AffixTypes.LIVELY.get(), "Lively");
        this.addAffix((IAffix)AffixTypes.MAGNETIC.get(), "Magnetic");
        this.addAffix((IAffix)AffixTypes.MOLTEN.get(), "Molten");
        this.addAffix((IAffix)AffixTypes.PARALYZING.get(), "Paralyzing");
        this.addAffix((IAffix)AffixTypes.PLAGUED.get(), "Plagued");
        this.addAffix((IAffix)AffixTypes.REFLECTIVE.get(), "Reflective");
        this.addAffix((IAffix)AffixTypes.SHIELDING.get(), "Shielding");
        this.addAffix((IAffix)AffixTypes.WOUNDING.get(), "Wounding");
        this.addRank(1, "Common");
        this.addRank(2, "Skilled");
        this.addRank(3, "Elite");
        this.addRank(4, "Legendary");
        this.addRank(5, "Ultimate");
        this.add((Item)ModItems.CHAMPION_EGG_ITEM.get(), "Champion Egg");
        this.add("item.champions.egg.tooltip", "Random Affixes");
        this.add((EntityType)ModEntityTypes.ENKINDLING_BULLET.get(), "Enkindling bullet");
        this.add((EntityType)ModEntityTypes.ARCTIC_BULLET.get(), "Arctic bullet");
        this.add((MobEffect)ModMobEffects.PARALYSIS_EFFECT_TYPE.get(), "Paralysis");
        this.add((MobEffect)ModMobEffects.WOUND_EFFECT_TYPE.get(), "Wound");
        this.addDamageType(ModDamageTypes.ENKINDLING_BULLET, "%1$s was struck by flames", "%1$s was struck by flames whilst fighting %2$s");
        this.addDamageType(ModDamageTypes.REFLECTION_DAMAGE, "%1$s got a taste of their own medicine", "");
        this.add("argument.champions.affix.unknown", "Unknown affix %s");
        this.add("commands.champions.summon.success", "Summoned new %s");
        this.add("commands.champions.egg.success", "Created new %s");
        this.add("command.champions.egg.unknown_entity", "Unknown entity");
        this.add("config.jade.plugin_champions.enable_affix_compact", "Enable Jade affix compact");
        this.add("advancements.champions.kill_a_champion.title", "Champion Hunter");
        this.add("advancements.champions.kill_a_champion.description", "Kill a powerful hostile monster");
        this.add("stat.champions.champion_mobs_killed", "Champion Mobs Killed");
    }

    protected void addTurkishTranslations() {
        this.addAffix((IAffix)AffixTypes.ADAPTABLE.get(), "Adaptif");
        this.addAffix((IAffix)AffixTypes.ARCTIC.get(), "Buz-gibi");
        this.addAffix((IAffix)AffixTypes.DAMPENING.get(), "So\u011furucu");
        this.addAffix((IAffix)AffixTypes.DESECRATING.get(), "Sayg\u0131s\u0131z");
        this.addAffix((IAffix)AffixTypes.ENKINDLING.get(), "Tutu\u015fturucu");
        this.addAffix((IAffix)AffixTypes.HASTY.get(), "Aceleci");
        this.addAffix((IAffix)AffixTypes.INFESTED.get(), "B\u00f6cekli");
        this.addAffix((IAffix)AffixTypes.KNOCKING.get(), "Tepici");
        this.addAffix((IAffix)AffixTypes.LIVELY.get(), "Ya\u015fam-dolu");
        this.addAffix((IAffix)AffixTypes.MAGNETIC.get(), "Manyetik");
        this.addAffix((IAffix)AffixTypes.MOLTEN.get(), "Erimi\u015f");
        this.addAffix((IAffix)AffixTypes.PARALYZING.get(), "Fel\u00e7-edici");
        this.addAffix((IAffix)AffixTypes.PLAGUED.get(), "Hastal\u0131kl\u0131");
        this.addAffix((IAffix)AffixTypes.REFLECTIVE.get(), "Yans\u0131t\u0131c\u0131");
        this.addAffix((IAffix)AffixTypes.SHIELDING.get(), "Korumal\u0131");
        this.addAffix((IAffix)AffixTypes.WOUNDING.get(), "Yaralay\u0131c\u0131");
        this.addRank(1, "Yayg\u0131n");
        this.addRank(2, "Yetenekli");
        this.addRank(3, "Elit");
        this.addRank(4, "Efsanevi");
        this.addRank(5, "Nihai");
        this.add((Item)ModItems.CHAMPION_EGG_ITEM.get(), "\u015eampiyon Yumurtas\u0131");
        this.add("item.champions.egg.tooltip", "Rasgele \u00d6zellikli");
        this.add((EntityType)ModEntityTypes.ENKINDLING_BULLET.get(), "Enkindling bullet");
        this.add((EntityType)ModEntityTypes.ARCTIC_BULLET.get(), "Arctic bullet");
        this.add((MobEffect)ModMobEffects.PARALYSIS_EFFECT_TYPE.get(), "Fel\u00e7");
        this.add((MobEffect)ModMobEffects.WOUND_EFFECT_TYPE.get(), "Yaralanma");
        this.addDamageType(ModDamageTypes.ENKINDLING_BULLET, "%1$s yand\u0131", "%1$s ,  %2$s ile sava\u015f\u0131rken yand\u0131.");
        this.addDamageType(ModDamageTypes.REFLECTION_DAMAGE, "%1$s kendi ilac\u0131n\u0131n tad\u0131na bakt\u0131", "");
        this.add("argument.champions.affix.unknown", "%s - Bilinmeyen \u00f6zellik");
        this.add("commands.champions.summon.success", "Yeni %s \u00e7a\u011fr\u0131ld\u0131");
        this.add("commands.champions.egg.success", "Yeni %s olu\u015fturuldu");
        this.add("command.champions.egg.unknown_entity", "Bilinmeyen Yarat\u0131k");
        this.add("config.jade.plugin_champions.enable_affix_compact", "Enable Jade affix compact");
        this.add("advancements.champions.kill_a_champion.title", "\u015eampiyon Avc\u0131s\u0131");
        this.add("advancements.champions.kill_a_champion.description", "G\u00fc\u00e7l\u00fc bir d\u00fc\u015fman \u00f6ld\u00fcr");
        this.add("stat.champions.champion_mobs_killed", "\u00d6ld\u00fcr\u00fclen \u015eampiyon Say\u0131s\u0131");
    }

    protected void addRussianTranslations() {
        this.addAffix((IAffix)AffixTypes.ADAPTABLE.get(), "\u0410\u0434\u0430\u043f\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.ARCTIC.get(), "\u0421\u043d\u0435\u0436\u043d\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.DAMPENING.get(), "\u0412\u043e\u0434\u044f\u043d\u0438\u0441\u0442\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.DESECRATING.get(), "\u041e\u0441\u043a\u0432\u0435\u0440\u043d\u0435\u043d\u043d\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.ENKINDLING.get(), "\u0420\u0430\u0441\u043a\u0430\u043b\u0451\u043d\u043d\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.HASTY.get(), "\u041b\u043e\u0432\u043a\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.INFESTED.get(), "\u0417\u0430\u0440\u0430\u0436\u0435\u043d\u043d\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.KNOCKING.get(), "\u041e\u0442\u0431\u0438\u0432\u0430\u044e\u0449\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.LIVELY.get(), "\u0416\u0438\u0432\u0443\u0447\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.MAGNETIC.get(), "\u041c\u0430\u0433\u043d\u0438\u0442\u043d\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.MOLTEN.get(), "\u0420\u0430\u0441\u043f\u043b\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.PARALYZING.get(), "\u041f\u0430\u0440\u0430\u043b\u0438\u0437\u0443\u044e\u0449\u0438\u0439");
        this.addAffix((IAffix)AffixTypes.PLAGUED.get(), "\u0427\u0443\u043c\u043d\u043e\u0439");
        this.addAffix((IAffix)AffixTypes.REFLECTIVE.get(), "\u0420\u0435\u0444\u043b\u0435\u043a\u0442\u043e\u0440\u043d\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.SHIELDING.get(), "\u0423\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u043d\u044b\u0439");
        this.addAffix((IAffix)AffixTypes.WOUNDING.get(), "\u0423\u0431\u043e\u0439\u043d\u044b\u0439");
        this.addRank(1, "\u041e\u0431\u044b\u043a\u043d\u043e\u0432\u0435\u043d\u043d\u044b\u0439");
        this.addRank(2, "\u0423\u043c\u0435\u043b\u044b\u0439");
        this.addRank(3, "\u042d\u043b\u0438\u0442\u043d\u044b\u0439");
        this.addRank(4, "\u041b\u0435\u0433\u0435\u043d\u0434\u0430\u0440\u043d\u044b\u0439");
        this.addRank(5, "\u0423\u043b\u044c\u0442\u0438\u043c\u0430\u0442\u0438\u0432\u043d\u044b\u0439");
        this.add((Item)ModItems.CHAMPION_EGG_ITEM.get(), "\u042f\u0439\u0446\u043e \u0427\u0435\u043c\u043f\u0438\u043e\u043d\u0441\u043a\u043e\u0433\u043e \u041c\u043e\u0431\u0430");
        this.add("item.champions.egg.tooltip", "\u041c\u043e\u0431 \u0441 \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u043c\u0438 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u044e\u0449\u0438\u043c\u0438 \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e\u0441\u0442\u044f\u043c\u0438");
        this.add((EntityType)ModEntityTypes.ENKINDLING_BULLET.get(), "Enkindling bullet");
        this.add((EntityType)ModEntityTypes.ARCTIC_BULLET.get(), "Arctic bullet");
        this.add((MobEffect)ModMobEffects.PARALYSIS_EFFECT_TYPE.get(), "\u041f\u0430\u0440\u0430\u043b\u0438\u0447");
        this.add((MobEffect)ModMobEffects.WOUND_EFFECT_TYPE.get(), "\u0420\u0430\u043d\u0435\u043d\u0438\u0435");
        this.addDamageType(ModDamageTypes.ENKINDLING_BULLET, "%1$s was struck by flames", "%1$s was struck by flames whilst fighting %2$s");
        this.addDamageType(ModDamageTypes.REFLECTION_DAMAGE, "%1$s \u043f\u043e\u043f\u0440\u043e\u0431\u043e\u0432\u0430\u043b \u043d\u0430 \u0432\u043a\u0443\u0441 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e", "");
        this.add("argument.champions.affix.unknown", "Unknown affix %s");
        this.add("commands.champions.summon.success", "\u041f\u0440\u0438\u0437\u0432\u0430\u043d \u043d\u043e\u0432\u044b\u0439 %s");
        this.add("commands.champions.egg.success", "\u0420\u043e\u0436\u0434\u0435\u043d \u043d\u043e\u0432\u044b\u0439 %s");
        this.add("command.champions.egg.unknown_entity", "Unknown entity");
        this.add("config.jade.plugin_champions.enable_affix_compact", "Enable Jade affix compact");
        this.add("advancements.champions.kill_a_champion.title", "\u041e\u0445\u043e\u0442\u043d\u0438\u043a \u043d\u0430 \u0427\u0435\u043c\u043f\u0438\u043e\u043d\u043e\u0432");
        this.add("advancements.champions.kill_a_champion.description", "\u0423\u0431\u0435\u0439\u0442\u0435 \u0447\u0435\u043c\u043f\u0438\u043e\u043d\u0441\u043a\u043e\u0433\u043e \u043c\u043e\u0431\u0430");
        this.add("stat.champions.champion_mobs_killed", "\u0423\u0431\u0438\u0442\u043e \u0447\u0435\u043c\u043f\u0438\u043e\u043d\u0441\u043a\u0438\u0445 \u043c\u043e\u0431\u043e\u0432");
    }

    protected void addKoreaTranslations() {
        this.addAffix((IAffix)AffixTypes.ADAPTABLE.get(), "\uc801\uc751");
        this.addAffix((IAffix)AffixTypes.ARCTIC.get(), "\uadf9\uc810");
        this.addAffix((IAffix)AffixTypes.DAMPENING.get(), "\uac10\uc1e0");
        this.addAffix((IAffix)AffixTypes.DESECRATING.get(), "\ubaa8\ub3c5");
        this.addAffix((IAffix)AffixTypes.ENKINDLING.get(), "\ub9f9\ud654");
        this.addAffix((IAffix)AffixTypes.HASTY.get(), "\uc2e0\uc18d");
        this.addAffix((IAffix)AffixTypes.INFESTED.get(), "\uac10\uc5fc");
        this.addAffix((IAffix)AffixTypes.KNOCKING.get(), "\ub109\ubc31");
        this.addAffix((IAffix)AffixTypes.LIVELY.get(), "\ud65c\ub825");
        this.addAffix((IAffix)AffixTypes.MAGNETIC.get(), "\uc790\ub825");
        this.addAffix((IAffix)AffixTypes.MOLTEN.get(), "\uc735\ud574");
        this.addAffix((IAffix)AffixTypes.PARALYZING.get(), "\ub9c8\ube44");
        this.addAffix((IAffix)AffixTypes.PLAGUED.get(), "\uc9c8\ubcd1");
        this.addAffix((IAffix)AffixTypes.REFLECTIVE.get(), "\ubc18\uc0ac");
        this.addAffix((IAffix)AffixTypes.SHIELDING.get(), "\ubc29\ud328");
        this.addAffix((IAffix)AffixTypes.WOUNDING.get(), "\uc0c1\ucc98");
        this.addRank(1, "\ud3c9\ubc94\ud55c");
        this.addRank(2, "\uc219\ub828\ub41c");
        this.addRank(3, "\uc5d8\ub9ac\ud2b8");
        this.addRank(4, "\uc804\uc124\uc801\uc778");
        this.addRank(5, "\uad81\uadf9\uc758");
        this.add((Item)ModItems.CHAMPION_EGG_ITEM.get(), "\ucc54\ud53c\uc5b8 \uc0dd\uc131 \uc54c");
        this.add("item.champions.egg.tooltip", "\ubb34\uc791\uc704 \uc218\uc2dd\uc5b4");
        this.add((EntityType)ModEntityTypes.ENKINDLING_BULLET.get(), "Enkindling bullet");
        this.add((EntityType)ModEntityTypes.ARCTIC_BULLET.get(), "Arctic bullet");
        this.add((MobEffect)ModMobEffects.PARALYSIS_EFFECT_TYPE.get(), "\ub9c8\ube44");
        this.add((MobEffect)ModMobEffects.WOUND_EFFECT_TYPE.get(), "\uc0c1\ucc98");
        this.addDamageType(ModDamageTypes.ENKINDLING_BULLET, "%1$s\uc740(\ub294) \ubd88\ud0c0\uc62c\ub790\uc2b5\ub2c8\ub2e4", "%1$s\uc740(\ub294) %2$s\uacfc(\uc640) \uc2f8\uc6b0\ub2e4\uac00 \ubd88\ud0c0\uc62c\ub790\uc2b5\ub2c8\ub2e4");
        this.addDamageType(ModDamageTypes.REFLECTION_DAMAGE, "%1$s\uc740(\ub294) \uc790\uae30 \uaf80\uc5d0 \uc790\uae30\uac00 \ub118\uc5b4\uac14\uc2b5\ub2c8\ub2e4", "");
        this.add("argument.champions.affix.unknown", "\uc54c \uc218 \uc5c6\ub294 \uc218\uc2dd\uc5b4 %s");
        this.add("commands.champions.summon.success", "\uc0c8\ub85c\uc6b4 %s\uc744(\ub97c) \uc18c\ud658");
        this.add("commands.champions.egg.success", "\uc0c8\ub85c\uc6b4 %s\uc744(\ub97c) \uc0dd\uc131");
        this.add("command.champions.egg.unknown_entity", "Unknown entity");
        this.add("config.jade.plugin_champions.enable_affix_compact", "Enable Jade affix compact");
        this.add("advancements.champions.kill_a_champion.title", "\ucc54\ud53c\uc5b8 \uc0ac\ub0e5\uafbc");
        this.add("advancements.champions.kill_a_champion.description", "\uac15\ub825\ud55c \uc801\ub300\uc801 \ubaac\uc2a4\ud130\ub97c \uc8fd\uc774\uc138\uc694");
        this.add("stat.champions.champion_mobs_killed", "\ucc54\ud53c\uc5b8 \ucc98\uce58");
    }

    protected void addDamageType(ResourceKey<DamageType> damageType, String translate, String byPlayerTranslate) {
        this.add("death.attack." + damageType.location().getPath(), translate);
        this.add("death.attack." + damageType.location().getPath() + ".player", byPlayerTranslate);
    }

    protected void addRank(int level, String translate) {
        this.add("rank.champions.title." + level, translate);
    }

    protected void addAffix(IAffix affix, String translate) {
        this.add("affix", affix.getIdentifier(), translate);
    }

    protected void add(String pre, String post, String translate) {
        this.add(pre + ":" + post, translate);
    }

    protected void add(String pre, ResourceLocation post, String translate) {
        this.add(post.toLanguageKey(pre), translate);
    }
}

