/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.serde.ObjectDeserializer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.config.ConfigLoot;
import top.theillusivec4.champions.common.config.EntitiesConfig;
import top.theillusivec4.champions.common.config.RanksConfig;

public class ChampionsConfig {
    public static final ModConfigSpec SERVER_SPEC;
    public static final ServerConfig SERVER;
    public static final ModConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static final ModConfigSpec STAGE_SPEC;
    public static final StageConfig STAGE;
    public static final ModConfigSpec RANKS_SPEC;
    public static final Ranks RANKS;
    public static final ModConfigSpec ENTITIES_SPEC;
    public static final Entities ENTITIES;
    private static final String CONFIG_PREFIX = "gui.champions.config.";
    public static List<RanksConfig.RankConfig> ranks;
    public static List<EntitiesConfig.EntityConfig> entities;
    public static int beaconProtectionRange;
    public static boolean championSpawners;
    public static int deathMessageTier;
    public static List<? extends String> dimensionList;
    public static ConfigEnums.Permission dimensionPermission;
    public static List<? extends String> entitiesList;
    public static ConfigEnums.Permission entitiesPermission;
    public static boolean showHud;
    public static boolean showParticles;
    public static boolean enableTOPIntegration;
    public static boolean fakeLoot;
    public static ConfigEnums.LootSource lootSource;
    public static boolean lootScaling;
    public static int experienceGrowth;
    public static int explosionGrowth;
    public static double affixTargetRange;
    public static double adaptableDamageReductionIncrement;
    public static double adaptableMaxDamageReduction;
    public static int arcticAttackInterval;
    public static double dampenedDamageReduction;
    public static int desecratingCloudInterval;
    public static int desecratingCloudActivationTime;
    public static double desecratingCloudRadius;
    public static int desecratingCloudDuration;
    public static int enkindlingAttackInterval;
    public static double hastyMovementBonus;
    public static int infestedAmount;
    public static int infestedInterval;
    public static double infestedPerHealth;
    public static int infestedTotal;
    public static EntityType<?> infestedParasite;
    public static EntityType<?> infestedEnderParasite;
    public static double paralyzingChance;
    public static double knockingMultiplier;
    public static int livelyCooldown;
    public static double livelyHealAmount;
    public static double livelyPassiveMultiplier;
    public static double magneticStrength;
    public static boolean moltenWaterResistance;
    public static MobEffectInstance plaguedEffect;
    public static int plaguedRange;
    public static double reflectiveMaxPercent;
    public static double reflectiveMinPercent;
    public static int reflectiveMax;
    public static boolean reflectiveLethal;
    public static double woundingChance;
    public static double shieldingChance;
    public static boolean mobInherit;
    public static int rankReduce;
    public static boolean canHaveInfestedAffix;
    public static List<? extends String> entityStages;
    public static List<? extends String> tierStages;
    public static List<? extends String> bossBarBlackList;
    public static boolean championTrialSpawners;
    public static boolean enableDebug;
    public static boolean allowChampionsList;
    public static ConfigEnums.Permission allowChampionsPermission;

    public static void transformRanks(CommentedConfig configData) {
        ChampionsConfig.RANKS.ranks = (RanksConfig)ObjectDeserializer.standard().deserializeFields((UnmodifiableConfig)configData, RanksConfig::new);
        ranks = ChampionsConfig.RANKS.ranks.ranks;
    }

    public static void transformEntities(CommentedConfig configData) {
        ChampionsConfig.ENTITIES.entities = (EntitiesConfig)ObjectDeserializer.standard().deserializeFields((UnmodifiableConfig)configData, EntitiesConfig::new);
        entities = ChampionsConfig.ENTITIES.entities.entities;
    }

    public static void bakeCommon() {
        beaconProtectionRange = (Integer)ChampionsConfig.COMMON.beaconProtectionRange.get();
        championSpawners = (Boolean)ChampionsConfig.COMMON.championSpawners.get();
        championTrialSpawners = (Boolean)ChampionsConfig.COMMON.championTrialSpawners.get();
        deathMessageTier = (Integer)ChampionsConfig.COMMON.deathMessageTier.get();
        dimensionList = (List)ChampionsConfig.COMMON.dimensionList.get();
        dimensionPermission = (ConfigEnums.Permission)((Object)ChampionsConfig.COMMON.dimensionPermission.get());
        entitiesList = (List)ChampionsConfig.COMMON.entitiesList.get();
        entitiesPermission = (ConfigEnums.Permission)((Object)ChampionsConfig.COMMON.entitiesPermission.get());
        showHud = (Boolean)ChampionsConfig.COMMON.showHud.get();
        showParticles = (Boolean)ChampionsConfig.COMMON.showParticles.get();
        enableTOPIntegration = (Boolean)ChampionsConfig.COMMON.enableTOPIntegration.get();
        bossBarBlackList = (List)ChampionsConfig.COMMON.bossBarBlackList.get();
        enableDebug = (Boolean)ChampionsConfig.COMMON.enableDebug.get();
        allowChampionsList = (Boolean)ChampionsConfig.COMMON.allowChampionsList.get();
        allowChampionsPermission = (ConfigEnums.Permission)((Object)ChampionsConfig.COMMON.allowChampionsPermission.get());
    }

    public static void bake() {
        fakeLoot = (Boolean)ChampionsConfig.SERVER.fakeLoot.get();
        lootSource = (ConfigEnums.LootSource)((Object)ChampionsConfig.SERVER.lootSource.get());
        lootScaling = (Boolean)ChampionsConfig.SERVER.lootScaling.get();
        ConfigLoot.parse((List)ChampionsConfig.SERVER.lootDrops.get());
        experienceGrowth = (Integer)ChampionsConfig.SERVER.experienceGrowth.get();
        explosionGrowth = (Integer)ChampionsConfig.SERVER.explosionGrowth.get();
        affixTargetRange = (Double)ChampionsConfig.SERVER.affixTargetRange.get();
        adaptableDamageReductionIncrement = (Double)ChampionsConfig.SERVER.adaptableDamageReductionIncrement.get();
        adaptableMaxDamageReduction = (Double)ChampionsConfig.SERVER.adaptableMaxDamageReduction.get();
        arcticAttackInterval = (Integer)ChampionsConfig.SERVER.arcticAttackInterval.get();
        dampenedDamageReduction = (Double)ChampionsConfig.SERVER.dampenedDamageReduction.get();
        desecratingCloudActivationTime = (Integer)ChampionsConfig.SERVER.desecratingCloudActivationTime.get();
        desecratingCloudDuration = (Integer)ChampionsConfig.SERVER.desecratingCloudDuration.get();
        desecratingCloudInterval = (Integer)ChampionsConfig.SERVER.desecratingCloudInterval.get();
        desecratingCloudRadius = (Double)ChampionsConfig.SERVER.desecratingCloudRadius.get();
        enkindlingAttackInterval = (Integer)ChampionsConfig.SERVER.enkindlingAttackInterval.get();
        hastyMovementBonus = (Double)ChampionsConfig.SERVER.hastyMovementBonus.get();
        infestedAmount = (Integer)ChampionsConfig.SERVER.infestedAmount.get();
        infestedTotal = (Integer)ChampionsConfig.SERVER.infestedTotal.get();
        infestedPerHealth = (Double)ChampionsConfig.SERVER.infestedPerHealth.get();
        infestedInterval = (Integer)ChampionsConfig.SERVER.infestedInterval.get();
        Optional type = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)((String)ChampionsConfig.SERVER.infestedParasite.get())));
        infestedParasite = type.isPresent() ? (EntityType)type.get() : EntityType.SILVERFISH;
        type = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)((String)ChampionsConfig.SERVER.infestedEnderParasite.get())));
        infestedEnderParasite = type.isPresent() ? (EntityType)type.get() : EntityType.ENDERMITE;
        paralyzingChance = (Double)ChampionsConfig.SERVER.paralyzingChance.get();
        knockingMultiplier = (Double)ChampionsConfig.SERVER.knockingMultiplier.get();
        livelyHealAmount = (Double)ChampionsConfig.SERVER.livelyHealAmount.get();
        livelyPassiveMultiplier = (Double)ChampionsConfig.SERVER.livelyPassiveMultiplier.get();
        livelyCooldown = (Integer)ChampionsConfig.SERVER.livelyCooldown.get();
        magneticStrength = (Double)ChampionsConfig.SERVER.magneticStrength.get();
        moltenWaterResistance = (Boolean)ChampionsConfig.SERVER.moltenWaterResistance.get();
        plaguedRange = (Integer)ChampionsConfig.SERVER.plaguedRange.get();
        try {
            String[] s = ((String)ChampionsConfig.SERVER.plaguedEffect.get()).split(";");
            if (s.length < 1) {
                throw new IllegalArgumentException();
            }
            Optional effect = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)s[0]));
            if (effect.isEmpty()) {
                throw new IllegalArgumentException();
            }
            plaguedEffect = s.length < 2 ? new MobEffectInstance((Holder)effect.get()) : (s.length < 3 ? new MobEffectInstance((Holder)effect.get(), Integer.parseInt(s[1]) * 20) : new MobEffectInstance((Holder)effect.get(), Integer.parseInt(s[1]) * 20, Integer.parseInt(s[2]) - 1));
        }
        catch (IllegalArgumentException e) {
            plaguedEffect = new MobEffectInstance(MobEffects.POISON, 300, 0);
            Champions.LOGGER.error("Error parsing plaguedEffect config value!");
        }
        reflectiveLethal = (Boolean)ChampionsConfig.SERVER.reflectiveLethal.get();
        reflectiveMax = (Integer)ChampionsConfig.SERVER.reflectiveMax.get();
        reflectiveMaxPercent = (Double)ChampionsConfig.SERVER.reflectiveMaxPercent.get();
        reflectiveMinPercent = (Double)ChampionsConfig.SERVER.reflectiveMinPercent.get();
        woundingChance = (Double)ChampionsConfig.SERVER.woundingChance.get();
        shieldingChance = (Double)ChampionsConfig.SERVER.shieldingChance.get();
        mobInherit = (Boolean)ChampionsConfig.SERVER.mobInherit.get();
        rankReduce = (Integer)ChampionsConfig.SERVER.rankReduce.get();
        canHaveInfestedAffix = (Boolean)ChampionsConfig.SERVER.canHaveInfestedAffix.get();
    }

    private static boolean validateEntityName(Object obj) {
        boolean valid = false;
        if (obj instanceof List) {
            List entityNameList = (List)obj;
            for (Object entityName : entityNameList) {
                ResourceLocation location = ResourceLocation.parse((String)((String)entityName));
                valid = BuiltInRegistries.ENTITY_TYPE.containsKey(location);
            }
        }
        return valid;
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ModConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        Pair specPair2 = new ModConfigSpec.Builder().configure(StageConfig::new);
        STAGE_SPEC = (ModConfigSpec)specPair2.getRight();
        STAGE = (StageConfig)specPair2.getLeft();
        specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Ranks::new);
        RANKS_SPEC = (ModConfigSpec)specPair.getRight();
        RANKS = (Ranks)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Entities::new);
        ENTITIES_SPEC = (ModConfigSpec)specPair.getRight();
        ENTITIES = (Entities)specPair.getLeft();
    }

    public static class Ranks {
        public RanksConfig ranks;

        public Ranks(ModConfigSpec.Builder builder) {
            builder.comment("List of ranks").define("ranks", new ArrayList());
            builder.build();
        }
    }

    public static class Entities {
        public EntitiesConfig entities;

        public Entities(ModConfigSpec.Builder builder) {
            builder.comment("List of entity configurations").define("entities", new ArrayList());
            builder.build();
        }
    }

    public static class CommonConfig {
        public final ModConfigSpec.IntValue beaconProtectionRange;
        public final ModConfigSpec.BooleanValue championSpawners;
        public final ModConfigSpec.IntValue deathMessageTier;
        public final ModConfigSpec.ConfigValue<List<? extends String>> dimensionList;
        public final ModConfigSpec.EnumValue<ConfigEnums.Permission> dimensionPermission;
        public final ModConfigSpec.ConfigValue<List<? extends String>> entitiesList;
        public final ModConfigSpec.EnumValue<ConfigEnums.Permission> entitiesPermission;
        public final ModConfigSpec.BooleanValue showHud;
        public final ModConfigSpec.BooleanValue showParticles;
        public final ModConfigSpec.BooleanValue enableTOPIntegration;
        public final ModConfigSpec.ConfigValue<List<? extends String>> bossBarBlackList;
        public final ModConfigSpec.BooleanValue championTrialSpawners;
        public ModConfigSpec.BooleanValue enableDebug;
        public ModConfigSpec.BooleanValue allowChampionsList;
        public ModConfigSpec.EnumValue<ConfigEnums.Permission> allowChampionsPermission;

        public CommonConfig(ModConfigSpec.Builder builder) {
            builder.push("general");
            this.enableDebug = builder.comment("Enable debug for game testing").translation("gui.champions.config.enableDebug").define("enableDebug", false);
            this.beaconProtectionRange = builder.comment("The range from an active beacon where no champions will spawn (0 to disable)").translation("gui.champions.config.beaconProtectionRange").defineInRange("beaconProtectionRange", 64, 0, 1000);
            this.championSpawners = builder.comment("Set to true to enable champions from normal mob spawners").translation("gui.champions.config.championSpawners").define("championSpawners", false);
            this.championTrialSpawners = builder.comment("Set to true to enable champions from trial spawners").translation("gui.champions.config.championTrialSpawners").define("championTrialSpawners", false);
            this.deathMessageTier = builder.comment("The minimum tier of champions that will have death messages sent out upon defeat (0 to disable)").translation("gui.champions.config.deathMessageTier").defineInRange("deathMessageTier", 0, 0, Integer.MAX_VALUE);
            this.dimensionList = builder.comment("A list of dimension names that are blacklisted/whitelisted for champions").translation("gui.champions.config.dimensionList").defineListAllowEmpty("dimensionList", new ArrayList(), () -> null, s -> s instanceof String);
            this.dimensionPermission = builder.comment("Set whether the dimension list is a blacklist or whitelist").translation("gui.champions.config.dimensionPermission").defineEnum("dimensionPermission", (Enum)ConfigEnums.Permission.BLACKLIST);
            this.entitiesList = builder.comment("A list of entities that are blacklisted/whitelisted for champions").translation("gui.champions.config.entitiesList").defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entitiesList"}), ArrayList::new, () -> null, s -> s instanceof String);
            this.entitiesPermission = builder.comment("Set whether the entities list is a blacklist or whitelist").translation("gui.champions.config.entitiesPermission").defineEnum("entitiesPermission", (Enum)ConfigEnums.Permission.BLACKLIST);
            this.showHud = builder.comment("Set to true to show HUD display for champions, including health, affixes, and tier").translation("gui.champions.config.showHud").define("showHud", true);
            this.bossBarBlackList = builder.comment("Set entity id (for example, ['minecraft:end_dragon', 'minecraft:creeper']) to hidden HUD display for champions, including health, affixes, and tier").translation("gui.champions.config.bossBarBlackList").defineListAllowEmpty("bossBarBlackList", List.of(), () -> null, ChampionsConfig::validateEntityName);
            this.showParticles = builder.comment("Set to true to have champions generate a colored particle effect indicating their rank").translation("gui.champions.config.showParticles").define("showParticles", true);
            this.enableTOPIntegration = builder.comment("Set to true to show champion tier and affixes in The One Probe overlay").translation("gui.champions.config.enableTOPIntegration").define("enableTOPIntegration", true);
            this.allowChampionsList = builder.comment("Set to true to enable champions entity allow list configuration by datapack").translation("gui.champions.config.allowChampionsList").define("allowChampionsList", true);
            this.allowChampionsPermission = builder.comment("The permission of champions entity allow list datapack.").translation("gui.champions.config.allowChampionsPermission").defineEnum("allowChampionsPermission", (Enum)ConfigEnums.Permission.WHITELIST, (Enum[])ConfigEnums.Permission.values());
            builder.pop();
        }
    }

    public static class ServerConfig {
        public final ModConfigSpec.BooleanValue fakeLoot;
        public final ModConfigSpec.EnumValue<ConfigEnums.LootSource> lootSource;
        public final ModConfigSpec.ConfigValue<List<? extends String>> lootDrops;
        public final ModConfigSpec.BooleanValue lootScaling;
        public final ModConfigSpec.IntValue experienceGrowth;
        public final ModConfigSpec.IntValue explosionGrowth;
        public final ModConfigSpec.DoubleValue affixTargetRange;
        public final ModConfigSpec.DoubleValue adaptableDamageReductionIncrement;
        public final ModConfigSpec.DoubleValue adaptableMaxDamageReduction;
        public final ModConfigSpec.IntValue arcticAttackInterval;
        public final ModConfigSpec.DoubleValue dampenedDamageReduction;
        public final ModConfigSpec.IntValue desecratingCloudInterval;
        public final ModConfigSpec.IntValue desecratingCloudActivationTime;
        public final ModConfigSpec.DoubleValue desecratingCloudRadius;
        public final ModConfigSpec.IntValue desecratingCloudDuration;
        public final ModConfigSpec.IntValue enkindlingAttackInterval;
        public final ModConfigSpec.DoubleValue hastyMovementBonus;
        public final ModConfigSpec.ConfigValue<String> infestedParasite;
        public final ModConfigSpec.ConfigValue<String> infestedEnderParasite;
        public final ModConfigSpec.IntValue infestedAmount;
        public final ModConfigSpec.IntValue infestedInterval;
        public final ModConfigSpec.DoubleValue infestedPerHealth;
        public final ModConfigSpec.IntValue infestedTotal;
        public final ModConfigSpec.DoubleValue paralyzingChance;
        public final ModConfigSpec.DoubleValue knockingMultiplier;
        public final ModConfigSpec.DoubleValue livelyHealAmount;
        public final ModConfigSpec.DoubleValue livelyPassiveMultiplier;
        public final ModConfigSpec.IntValue livelyCooldown;
        public final ModConfigSpec.DoubleValue magneticStrength;
        public final ModConfigSpec.BooleanValue moltenWaterResistance;
        public final ModConfigSpec.ConfigValue<String> plaguedEffect;
        public final ModConfigSpec.IntValue plaguedRange;
        public final ModConfigSpec.DoubleValue reflectiveMinPercent;
        public final ModConfigSpec.DoubleValue reflectiveMaxPercent;
        public final ModConfigSpec.IntValue reflectiveMax;
        public final ModConfigSpec.BooleanValue reflectiveLethal;
        public final ModConfigSpec.DoubleValue woundingChance;
        public final ModConfigSpec.DoubleValue shieldingChance;
        public final ModConfigSpec.ConfigValue<List<? extends String>> scalingHealthSpawnModifiers;
        public final ModConfigSpec.BooleanValue mobInherit;
        public final ModConfigSpec.IntValue rankReduce;
        public final ModConfigSpec.BooleanValue canHaveInfestedAffix;

        public ServerConfig(ModConfigSpec.Builder builder) {
            builder.push("mobSplitSetting");
            this.mobInherit = builder.comment("Set to true to allow slime like mob when splitting, inherit this parentMob's affix and ranks.").translation("gui.champions.config.mobInherit").define("mobInherit", false);
            this.rankReduce = builder.comment("Set the children mob reduce rank when split, 0 means disable").translation("gui.champions.config.rankReduce").defineInRange("rankReduce", 1, 0, Integer.MAX_VALUE);
            this.canHaveInfestedAffix = builder.comment("Set the children mob can have Infested Affix, avoid the server splited too much entity").translation("gui.champions.config.canHaveInfestedAffix").define("canHaveInfestedAffix", false);
            builder.pop();
            builder.push("loot");
            this.fakeLoot = builder.comment("Set to true to allow fake players to generate champion loot").translation("gui.champions.config.fakeLoot").define("fakeLoot", false);
            this.lootSource = builder.comment("Set the source of champion mob drops").translation("gui.champions.config.lootSource").defineEnum("lootSource", (Enum)ConfigEnums.LootSource.LOOT_TABLE);
            this.lootDrops = builder.comment("List of loot drops from champions if sourced from config\nFormat: [tier];[modid:name];[amount];[enchant(true/false)];[weight]").translation("gui.champions.config.lootDrops").defineListAllowEmpty("lootDrops", new ArrayList(), () -> null, s -> s instanceof String);
            this.lootScaling = builder.comment("Set to true to scale amount of loot drops from champions to tier if sourced from config").translation("gui.champions.config.lootScaling").define("lootScaling", false);
            builder.pop();
            builder.push("growth");
            this.experienceGrowth = builder.comment("The increase in experience multiplied by the growth factor").translation("gui.champions.config.experienceGrowth").defineInRange("experienceGrowth", 1, 0, Integer.MAX_VALUE);
            this.explosionGrowth = builder.comment("The increase in explosive range multiplied by the growth factor").translation("gui.champions.config.explosionGrowth").defineInRange("explosionGrowth", 2, 0, 100);
            builder.pop();
            builder.push("affixes");
            this.affixTargetRange = builder.comment("Set the maximum distance that mobs can use their targeted abilities from, 0 to disable").translation("gui.champions.config.affixTargetRange").defineInRange("affixTargetRange", 0.0, 0.0, 100.0);
            builder.push("adaptable");
            this.adaptableDamageReductionIncrement = builder.comment("The increase in damage reduction for each consecutive attack of the same damage type").translation("gui.champions.config.adaptableDamageReductionIncrement").defineInRange("adaptableDamageReductionIncrement", 0.15, 0.0, 1.0);
            this.adaptableMaxDamageReduction = builder.comment("The maximum damage reduction").translation("gui.champions.config.adaptableMaxDamageReduction").defineInRange("adaptableMaxDamageReduction", 0.9, 0.0, 1.0);
            builder.pop();
            builder.push("arctic");
            this.arcticAttackInterval = builder.comment("How often the champion will shoot projectiles (in seconds)").translation("gui.champions.config.arcticAttackInterval").defineInRange("arcticAttackInterval", 1, 1, 100);
            builder.pop();
            builder.push("dampened");
            this.dampenedDamageReduction = builder.comment("The amount of damage reduction to apply to indirect attacks").translation("gui.champions.config.dampenedDamageReduction").defineInRange("dampenedDamageReduction", 0.8, 0.0, 1.0);
            builder.pop();
            builder.push("desecrating");
            this.desecratingCloudInterval = builder.comment("How long (in seconds) between cloud placements").translation("gui.champions.config.desecratingCloudInterval").defineInRange("desecratingCloudInterval", 3, 1, Integer.MAX_VALUE);
            this.desecratingCloudActivationTime = builder.comment("How long (in seconds) it takes for the effect cloud to activate after being placed").translation("gui.champions.config.desecratingCloudActivationTime").defineInRange("desecratingCloudActivationTime", 1, 0, Integer.MAX_VALUE);
            this.desecratingCloudRadius = builder.comment("The radius of the cloud effect").translation("gui.champions.config.desecratingCloudRadius").defineInRange("desecratingCloudRadius", 4.0, 1.0, Double.MAX_VALUE);
            this.desecratingCloudDuration = builder.comment("The duration (in seconds) of the cloud effect").translation("gui.champions.config.desecratingCloudDuration").defineInRange("desecratingCloudDuration", 10, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("enkindling");
            this.enkindlingAttackInterval = builder.comment("How often the champion will shoot projectiles (in seconds)").translation("gui.champions.config.enkindlingAttackInterval").defineInRange("enkindlingAttackInterval", 1, 1, 100);
            builder.pop();
            builder.push("hasty");
            this.hastyMovementBonus = builder.comment("The base movement speed bonus").translation("gui.champions.config.hastyMovementBonus").defineInRange("hastyMovementBonus", 0.25, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("infested");
            this.infestedAmount = builder.comment("The amount of parasites to spawn per interval").translation("gui.champions.config.infestedAmount").defineInRange("infestedAmount", 2, 1, 100);
            this.infestedInterval = builder.comment("The time (in seconds) between parasite spawns").translation("gui.champions.config.infestedInterval").defineInRange("infestedInterval", 3, 1, 100);
            this.infestedPerHealth = builder.comment("The amount of parasites to infest per health point of the champion").translation("gui.champions.config.infestedPerHealth").defineInRange("infestedPerHealth", 0.5, 0.0, Double.MAX_VALUE);
            this.infestedTotal = builder.comment("The total amount of parasites a champion can house at once").translation("gui.champions.config.infestedTotal").defineInRange("infestedTotal", 20, 1, Integer.MAX_VALUE);
            this.infestedParasite = builder.comment("The mob to use as a parasite for infestation").translation("gui.champions.config.infestedParasite").define("infestedParasite", (Object)"minecraft:silverfish");
            this.infestedEnderParasite = builder.comment("The mob to use as a parasite for infestation of ender mob").translation("gui.champions.config.infestedEnderParasite").define("infestedEnderParasite", (Object)"minecraft:endermite");
            builder.pop();
            builder.push("paralyzing");
            this.paralyzingChance = builder.comment("The percent chance that an attack will paralyze targets").translation("gui.champions.config.paralyzingChance").defineInRange("paralyzingChance", 0.2, 0.0, 1.0);
            builder.pop();
            builder.push("knocking");
            this.knockingMultiplier = builder.comment("The multiplier to apply to the knockback strength").translation("gui.champions.config.knockingMultiplier").defineInRange("knockingMultiplier", 5.0, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("lively");
            this.livelyHealAmount = builder.comment("The amount of health per second regeneration").translation("gui.champions.config.livelyHealAmount").defineInRange("livelyHealAmount", 1.0, 0.0, Double.MAX_VALUE);
            this.livelyPassiveMultiplier = builder.comment("Multiplier to health regeneration when not aggressive").translation("gui.champions.config.livelyPassiveMultiplier").defineInRange("livelyPassiveMultiplier", 5.0, 1.0, Double.MAX_VALUE);
            this.livelyCooldown = builder.comment("Set cooldown (in seconds) for regeneration after getting attacked").translation("gui.champions.config.livelyCooldown").defineInRange("livelyCooldown", 3, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("molten");
            this.moltenWaterResistance = builder.comment("Set to true to have Molten champions not be damaged by water").translation("gui.champions.config.moltenWaterResistance").define("moltenWaterResistance", false);
            builder.pop();
            builder.push("plagued");
            this.plaguedEffect = builder.comment("The effect that will be spread\nFormat:[effect];[power];[duration(secs)]").translation("gui.champions.config.plaguedEffect").define("plaguedEffect", (Object)"minecraft:poison;15;1");
            this.plaguedRange = builder.comment("The range of the plagued effect").translation("gui.champions.config.plaguedRange").defineInRange("plaguedRange", 5, 1, 100);
            builder.pop();
            builder.push("reflective");
            this.reflectiveMinPercent = builder.comment("The minimum percent of damage to reflect back").translation("gui.champions.config.reflectiveMinPercent").defineInRange("reflectiveMinPercent", 0.1, 0.0, 1.0);
            this.reflectiveMaxPercent = builder.comment("The maximum percent of damage to reflect back").translation("gui.champions.config.reflectiveMaxPercent").defineInRange("reflectiveMaxPercent", 0.35, 0.0, 1.0);
            this.reflectiveMax = builder.comment("The maximum amount of damage to reflect back").translation("gui.champions.config.reflectiveMax").defineInRange("reflectiveMax", 100, 0, Integer.MAX_VALUE);
            this.reflectiveLethal = builder.comment("Set to true to enable deadly reflected strikes").translation("gui.champions.config.reflectiveLethal").define("reflectiveLethal", true);
            builder.pop();
            builder.push("magnetic");
            this.magneticStrength = builder.comment("Strength of the magnetic pulling effect").translation("gui.champions.config.magneticStrength").defineInRange("magneticStrength", 0.05, 0.0, 100.0);
            builder.pop();
            builder.push("wounding");
            this.woundingChance = builder.comment("The percent chance that an attack will wound targets").translation("gui.champions.config.woundingChance").defineInRange("woundingChance", 0.4, 0.0, 1.0);
            builder.pop();
            builder.push("shielding");
            this.shieldingChance = builder.comment("The percent chance that an attack will wound targets").translation("gui.champions.config.shieldingChance").defineInRange("shieldingChance", 0.5, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("integrations");
            this.scalingHealthSpawnModifiers = builder.comment("Scaling Health\nList of tiers with numbers to multiply spawn rates by difficulty\nFormat: [tier];[percent increase]").translation("gui.champions.config.scalingHealthSpawnModifiers").defineListAllowEmpty("scalingHealthSpawnModifiers", new ArrayList(), () -> null, s -> s instanceof String);
            builder.pop();
        }
    }

    public static class StageConfig {
        public final ModConfigSpec.ConfigValue<List<? extends String>> entityStages;
        public final ModConfigSpec.ConfigValue<List<? extends String>> tierStages;

        public StageConfig(ModConfigSpec.Builder builder) {
            this.entityStages = builder.comment("A list of entity stages in the format: \"stage;modid:entity\" or \"stage;modid:entity;modid:dimension\"\nExample: \"test_stage;minecraft:zombie\" or \"test_stage;minecraft:spider;minecraft:the_nether\"").translation("gui.champions.config.entityStages").defineListAllowEmpty("entityStages", new ArrayList(), () -> null, s -> s instanceof String);
            this.tierStages = builder.comment("A list of tier stages in the format: \"stage;tier\" or \"stage;tier;modid:dimension\"\nExample: \"test_stage;2\" or \"test_stage;3;minecraft:the_nether\"").translation("gui.champions.config.tierStages").defineListAllowEmpty("tierStages", new ArrayList(), () -> null, s -> s instanceof String);
        }
    }
}

