/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.integration.jade;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.client.integration.jade.StarElement;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.Utils;

public enum ChampionComponentProvider implements IEntityComponentProvider
{
    INSTANCE;


    private static Component getChampionName(Tuple<Integer, String> rank, IChampion champion) {
        return Component.translatable((String)("rank.champions.title." + String.valueOf(rank.getA()))).append(" " + champion.getLivingEntity().getName().getString()).withColor(Rank.getColor((String)rank.getB()));
    }

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        ChampionAttachment.getAttachment(entityAccessor.getEntity()).ifPresent(champion -> {
            IChampion.Client clientChampion = champion.getClient();
            if (ChampionHelper.isValidChampion(clientChampion)) {
                champion.getClient().getRank().ifPresent(rank -> {
                    iTooltip.replace(JadeIds.CORE_OBJECT_NAME, ChampionComponentProvider.getChampionName((Tuple<Integer, String>)rank, champion));
                    StarElement starElement = StarElement.of((Integer)rank.getA(), (String)rank.getB(), ClientChampionsConfig.jadeStarSpacing);
                    iTooltip.add(1, (IElement)starElement);
                });
                champion.getClient().getAffixes().forEach(affix -> iTooltip.add((Component)Component.translatable((String)affix.toLanguageKey())));
            }
        });
    }

    public ResourceLocation getUid() {
        return Utils.getLocation("enable_affix_compact");
    }
}

