/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client;

import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import top.theillusivec4.champions.client.ChampionsOverlay;
import top.theillusivec4.champions.client.renderer.ColorizedBulletRenderer;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.particle.RankParticle;
import top.theillusivec4.champions.common.registry.ModEntityTypes;
import top.theillusivec4.champions.common.registry.ModItems;
import top.theillusivec4.champions.common.registry.ModParticleTypes;
import top.theillusivec4.champions.common.util.Utils;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="champions")
public class ClientModEventHandler {
    @SubscribeEvent
    public static void onRegisterColor(RegisterColorHandlersEvent.Item event) {
        event.register(ChampionEggItem::getColor, new ItemLike[]{(ItemLike)ModItems.CHAMPION_EGG_ITEM.get()});
    }

    @SubscribeEvent
    public static void registerGuiOverlayEvent(RegisterGuiLayersEvent evt) {
        evt.registerBelow(VanillaGuiLayers.BOSS_OVERLAY, Utils.getLocation("health_overlay"), (LayeredDraw.Layer)new ChampionsOverlay());
    }

    @SubscribeEvent
    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent evt) {
        evt.registerSpriteSet((ParticleType)ModParticleTypes.RANK_PARTICLE_TYPE.get(), RankParticle.RankFactory::new);
    }

    @SubscribeEvent
    public static void rendererRegistering(EntityRenderersEvent.RegisterRenderers evt) {
        evt.registerEntityRenderer((EntityType)ModEntityTypes.ARCTIC_BULLET.get(), renderManager -> new ColorizedBulletRenderer(renderManager, 4388323));
        evt.registerEntityRenderer((EntityType)ModEntityTypes.ENKINDLING_BULLET.get(), renderManager -> new ColorizedBulletRenderer(renderManager, 16538115));
    }
}

