/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.content;

import com.supermartijn642.pottery.content.DecorationUtils;
import com.supermartijn642.pottery.content.PotBlock;
import com.supermartijn642.pottery.content.PotBlockEntity;
import com.supermartijn642.pottery.content.PotColor;
import com.supermartijn642.pottery.content.PotType;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.NeoForge;

public class PotEventHandlers {
    public static void registerListeners() {
        NeoForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = PotEventHandlers.onInteract(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        });
    }

    private static InteractionResult onInteract(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity decorations2;
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = hitResult.getBlockPos();
        BlockState state = level.getBlockState(pos);
        if (state.is(Blocks.WATER_CAULDRON)) {
            Block block;
            ItemStack stack = player.getItemInHand(hand);
            if (stack.getItem() instanceof BlockItem && (block = ((BlockItem)stack.getItem()).getBlock()) instanceof PotBlock) {
                PotBlock block2 = (PotBlock)block;
                if (block2.getColor() == PotColor.BLANK) {
                    return InteractionResult.CONSUME;
                }
                if (!level.isClientSide) {
                    ItemStack newStack = new ItemStack((ItemLike)block2.getType().getItem(PotColor.BLANK), stack.getCount());
                    newStack.applyComponents(stack.getComponentsPatch());
                    player.setItemInHand(hand, newStack);
                    LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!state.is(Blocks.DECORATED_POT)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof DyeItem) {
            PotColor color = PotColor.colorForDye(((DyeItem)stack.getItem()).getDyeColor());
            if (color == null || color == PotColor.BLANK) {
                return InteractionResult.CONSUME;
            }
            if (!level.isClientSide) {
                BlockEntity entity = level.getBlockEntity(pos);
                if (!(entity instanceof DecoratedPotBlockEntity)) {
                    return InteractionResult.CONSUME;
                }
                PotDecorations decorations2 = ((DecoratedPotBlockEntity)entity).getDecorations();
                BlockState newState = (BlockState)((BlockState)((BlockState)PotType.DEFAULT.getBlock(color).defaultBlockState().setValue((Property)PotBlock.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)PotBlock.HORIZONTAL_FACING)))).setValue((Property)PotBlock.CRACKED, (Comparable)((Boolean)state.getValue((Property)PotBlock.CRACKED)))).setValue((Property)PotBlock.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)PotBlock.WATERLOGGED)));
                level.setBlock(pos, newState, 3);
                entity = level.getBlockEntity(pos);
                if (entity instanceof PotBlockEntity) {
                    ((PotBlockEntity)entity).updateDecorations(decorations2);
                }
                if (!player.isCreative()) {
                    stack = stack.copy();
                    stack.shrink(1);
                    player.setItemInHand(hand, stack);
                }
            }
            return InteractionResult.SUCCESS;
        }
        Direction hitSide = hitResult.getDirection();
        if (hitSide.getAxis().isHorizontal() && stack.is(ItemTags.DECORATED_POT_INGREDIENTS) && (decorations2 = level.getBlockEntity(pos)) instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity entity = (DecoratedPotBlockEntity)decorations2;
            Optional<Item> oldItem = DecorationUtils.getDecorationItem((PotDecorations)(decorations2 = entity.getDecorations()), (Direction)state.getValue((Property)PotBlock.HORIZONTAL_FACING), hitSide);
            if (stack.is(oldItem.orElse(Items.BRICK))) {
                return InteractionResult.CONSUME;
            }
            if (!level.isClientSide) {
                PotDecorations newDecorations = DecorationUtils.setDecorationItem((PotDecorations)decorations2, (Direction)state.getValue((Property)PotBlock.HORIZONTAL_FACING), hitSide, Optional.of(stack.getItem()));
                entity.setFromItem(DecoratedPotBlockEntity.createDecoratedPotItem((PotDecorations)newDecorations));
                entity.setChanged();
                level.sendBlockUpdated(pos, state, state, 2);
                if (!player.isCreative()) {
                    stack = stack.copy();
                    stack.shrink(1);
                    player.setItemInHand(hand, stack);
                    player.getInventory().placeItemBackInInventory(oldItem.orElse(Items.BRICK).getDefaultInstance());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

