/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.utils.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;

public class NeurogelMendingItem
extends Item {
    public NeurogelMendingItem(Item.Properties p) {
        super(p);
    }

    public int maxRepairPoints() {
        return 320;
    }

    public double maxRepairPercentage() {
        return 0.25;
    }

    public static void handleItem(ItemStackedOnOtherEvent event) {
        ItemStack itemToRepair = event.getStackedOnItem();
        ItemStack itemBeingCarried = event.getCarriedItem();
        Player player = event.getPlayer();
        Item item = itemBeingCarried.getItem();
        if (item instanceof NeurogelMendingItem) {
            NeurogelMendingItem neurogel = (NeurogelMendingItem)item;
            if (itemToRepair.isDamaged()) {
                int maxDurability = itemToRepair.getMaxDamage();
                int damage = itemToRepair.getDamageValue();
                int repairAmount = (int)Math.max((double)maxDurability * neurogel.maxRepairPercentage(), (double)neurogel.maxRepairPoints());
                itemBeingCarried.shrink(1);
                itemToRepair.setDamageValue(Math.max(damage - repairAmount, 0));
                player.playSound((SoundEvent)RegisterSounds.NEUROGEL_APPLY.get(), 0.75f, MiscUtils.randomInRange(0.8f, 1.2f));
                event.setCanceled(true);
            } else if (itemToRepair.is(Items.CHIPPED_ANVIL) || itemToRepair.is(Items.DAMAGED_ANVIL)) {
                neurogel.handleAnvilItem(event.getSlot(), player, itemBeingCarried, itemToRepair, event);
            }
        }
    }

    public void handleAnvilItem(Slot slot, Player player, ItemStack stackedOn, ItemStack itemToRepair, ItemStackedOnOtherEvent event) {
        ItemStack result;
        stackedOn.shrink(1);
        player.playSound((SoundEvent)RegisterSounds.NEUROGEL_APPLY.get(), 0.75f, MiscUtils.randomInRange(0.8f, 1.2f));
        ItemStack itemStack = result = itemToRepair.is(Items.CHIPPED_ANVIL) ? Items.ANVIL.getDefaultInstance() : Items.CHIPPED_ANVIL.getDefaultInstance();
        if (itemToRepair.getCount() == 1) {
            slot.set(result);
        } else {
            player.addItem(result);
            itemToRepair.shrink(1);
        }
        event.setCanceled(true);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(context.getClickedPos());
        if (player != null && (state.is(Blocks.CHIPPED_ANVIL) || state.is(Blocks.DAMAGED_ANVIL))) {
            BlockState anvil = Blocks.ANVIL.withPropertiesOf(state);
            BlockState chipped = Blocks.CHIPPED_ANVIL.withPropertiesOf(state);
            if (state.is(Blocks.CHIPPED_ANVIL)) {
                level.setBlockAndUpdate(pos, anvil);
            } else if (state.is(Blocks.DAMAGED_ANVIL)) {
                level.setBlockAndUpdate(pos, chipped);
            }
            stack.shrink(1);
            player.playSound((SoundEvent)RegisterSounds.NEUROGEL_APPLY.get(), 0.75f, MiscUtils.randomInRange(0.8f, 1.2f));
            return InteractionResult.CONSUME;
        }
        return super.onItemUseFirst(stack, context);
    }
}

