/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.renderer.ExperienceObeliskItemRenderer;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.cyanogen.cognition.utils.ItemUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ExperienceObeliskItem
extends BlockItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");

    public ExperienceObeliskItem(Block block, Item.Properties p) {
        super(block, p);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, this::controller));
    }

    protected <E extends ExperienceObeliskItem> PlayState controller(AnimationState<E> state) {
        AnimationController controller = state.getController();
        controller.setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private final BlockEntityWithoutLevelRenderer renderer = new ExperienceObeliskItemRenderer();

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CompoundTag tag = ItemUtils.getBlockEntityTag(stack);
        if (tag.contains("Fluid")) {
            int amount = tag.getCompound("Fluid").getInt("amount");
            int levels = ExperienceUtils.xpToLevels(amount / 20);
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.cognition.experience_obelisk.item_levels", (Object[])new Object[]{Component.literal((String)String.valueOf(levels)).withStyle(ChatFormatting.GREEN)}));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.cognition.experience_obelisk.item_points", (Object[])new Object[]{Component.literal((String)String.valueOf(amount / 20)).withStyle(ChatFormatting.GREEN)}));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

