/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block;

import com.cyanogen.cognition.block.ExperienceReceivingBlock;
import com.cyanogen.cognition.block_entities.PrecisionDispellerEntity;
import com.cyanogen.cognition.gui.PrecisionDispellerMenu;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrecisionDispellerBlock
extends ExperienceReceivingBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public PrecisionDispellerBlock() {
        super(BlockBehaviour.Properties.of().strength(9.0f).destroyTime(1.2f).requiresCorrectToolForDrops().explosionResistance(9.0f).noOcclusion().lightLevel(pLightEmission -> 7).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        super.createBlockStateDefinition(builder);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.sidedSuccess((boolean)true);
        }
        player.openMenu(this.getMenuProvider(state, level, pos), pos);
        return InteractionResult.CONSUME;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        if (!level.isClientSide && result == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            player.openMenu(this.getMenuProvider(state, level, pos), pos);
            return ItemInteractionResult.sidedSuccess((boolean)false);
        }
        return result;
    }

    @NotNull
    public MenuProvider getMenuProvider(BlockState state, Level level, final BlockPos pos) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Precision Dispeller");
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                return new PrecisionDispellerMenu(containerId, inventory, pos);
            }
        };
    }

    public VoxelShape getShapeEW() {
        VoxelShape shape1 = Shapes.create((AABB)new AABB(0.125, 0.25, 0.25, 0.875, 1.0, 0.75));
        VoxelShape shape2a = Shapes.create((AABB)new AABB(0.3125, 0.0, 0.71875, 0.6875, 0.4375, 0.90625));
        VoxelShape shape2b = Shapes.create((AABB)new AABB(0.375, 0.4375, 0.71875, 0.375, 0.8125, 0.875));
        VoxelShape shape2 = Shapes.join((VoxelShape)shape2a, (VoxelShape)shape2b, (BooleanOp)BooleanOp.OR);
        VoxelShape shape3a = Shapes.create((AABB)new AABB(0.3125, 0.0, 0.09375, 0.6875, 0.4375, 0.28125));
        VoxelShape shape3b = Shapes.create((AABB)new AABB(0.375, 0.4375, 0.125, 0.375, 0.8125, 0.28125));
        VoxelShape shape3 = Shapes.join((VoxelShape)shape3a, (VoxelShape)shape3b, (BooleanOp)BooleanOp.OR);
        return Shapes.join((VoxelShape)Shapes.join((VoxelShape)shape1, (VoxelShape)shape2, (BooleanOp)BooleanOp.OR), (VoxelShape)shape3, (BooleanOp)BooleanOp.OR).optimize();
    }

    public VoxelShape getShapeNS() {
        VoxelShape shape4 = Shapes.create((AABB)new AABB(0.25, 0.25, 0.125, 0.75, 1.0, 0.875));
        VoxelShape shape5a = Shapes.create((AABB)new AABB(0.71875, 0.0, 0.3125, 0.90625, 0.4375, 0.6875));
        VoxelShape shape5b = Shapes.create((AABB)new AABB(0.71875, 0.4375, 0.375, 0.875, 0.8125, 0.375));
        VoxelShape shape5 = Shapes.join((VoxelShape)shape5a, (VoxelShape)shape5b, (BooleanOp)BooleanOp.OR);
        VoxelShape shape6a = Shapes.create((AABB)new AABB(0.09375, 0.0, 0.3125, 0.28125, 0.4375, 0.6875));
        VoxelShape shape6b = Shapes.create((AABB)new AABB(0.125, 0.4375, 0.375, 0.28125, 0.8125, 0.375));
        VoxelShape shape6 = Shapes.join((VoxelShape)shape6a, (VoxelShape)shape6b, (BooleanOp)BooleanOp.OR);
        return Shapes.join((VoxelShape)Shapes.join((VoxelShape)shape5, (VoxelShape)shape6, (BooleanOp)BooleanOp.OR), (VoxelShape)shape4, (BooleanOp)BooleanOp.OR).optimize();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValues().get(FACING);
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            return this.getShapeNS();
        }
        return this.getShapeEW();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == RegisterBlockEntities.PRECISION_DISPELLER.get() ? PrecisionDispellerEntity::tick : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)RegisterBlockEntities.PRECISION_DISPELLER.get()).create(pos, state);
    }
}

