/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hidoni.transmog.Constants;
import com.hidoni.transmog.config.TooltipDetailLevel;
import com.hidoni.transmog.config.TransmogRenderOption;
import com.hidoni.transmog.platform.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class Config {
    public static TransmogRenderOption renderOption = TransmogRenderOption.IN_WORLD;
    public static TooltipDetailLevel tooltipDetailLevel = TooltipDetailLevel.FULL;
    public static int pvpDisableDuration = 0;
    private static final transient Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).serializeNulls().serializeSpecialFloatingPointValues().setPrettyPrinting().setLenient().create();

    public static Path getConfigPath() {
        return Services.PLATFORM.getConfigDirectory().resolve("transmog.json");
    }

    public static void loadConfigFromFile() {
        Path configPath = Config.getConfigPath();
        try {
            GSON.fromJson(Files.readString(configPath), Config.class);
        }
        catch (IOException e) {
            Constants.LOG.warn("Failed to read config file from " + String.valueOf(configPath), (Throwable)e);
        }
    }

    public static void writeConfigToFile() {
        Path configPath = Config.getConfigPath();
        try {
            String jsonString = GSON.toJson((Object)new Config());
            Files.writeString(configPath, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (IOException e) {
            Constants.LOG.warn("Failed to write config file to " + String.valueOf(configPath), (Throwable)e);
        }
    }
}

