/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.items;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wile.redstonepen.blocks.ControlBox;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Overlay;
import wile.redstonepen.libmc.StandardItems;

public class RemoteItem
extends StandardItems.BaseItem {
    public RemoteItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        RemoteData data = this.getRemoteData(stack).orElse(null);
        if (data != null) {
            tooltip.add((Component)Auxiliaries.localizable("item.redstonepen.remote.tooltip.linkedto", data.pos.getX(), data.pos.getY(), data.pos.getZ(), Component.translatable((String)data.name)));
        } else {
            tooltip.add((Component)Auxiliaries.localizable("item.redstonepen.remote.tooltip.notlinked"));
        }
        Auxiliaries.Tooltip.addInformation(stack, ctx, tooltip, flag, true);
    }

    @Override
    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return false;
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        ItemStack stack = player.getMainHandItem().getItem() instanceof RemoteItem ? player.getMainHandItem() : player.getOffhandItem();
        this.attack(stack, pos, player);
        return false;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        this.attack(stack, pos, player);
        return false;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return 10000.0f;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!(world instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        ServerLevel sworld = (ServerLevel)world;
        this.onTriggerRemoteLink(sworld, (ServerPlayer)player, player.getItemInHand(hand));
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel sworld = (ServerLevel)level;
        this.onTriggerRemoteLink(sworld, (ServerPlayer)context.getPlayer(), stack);
        return InteractionResult.CONSUME;
    }

    private void onTriggerRemoteLink(ServerLevel world, ServerPlayer player, ItemStack stack) {
        RemoteData data = this.getRemoteData(stack).orElse(null);
        if (data == null) {
            return;
        }
        BiConsumer<SoundEvent, Float> sound = (event, pitch) -> world.playSound(null, player.blockPosition(), event, SoundSource.PLAYERS, 0.25f, pitch.floatValue());
        Runnable fail = () -> sound.accept(SoundEvents.ENDERMAN_HURT, Float.valueOf(1.8f));
        BlockPos pos = data.pos;
        if (!world.isLoaded(pos)) {
            fail.run();
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (!state.hasProperty((Property)BlockStateProperties.POWERED)) {
            fail.run();
            return;
        }
        Block block = state.getBlock();
        boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
        if (block instanceof ButtonBlock) {
            ButtonBlock button = (ButtonBlock)block;
            if (powered) {
                return;
            }
            button.press(state, (Level)world, pos, null);
            sound.accept(SoundEvents.STONE_BUTTON_CLICK_ON, Float.valueOf(1.7f));
        } else if (block instanceof LeverBlock) {
            LeverBlock lever = (LeverBlock)block;
            lever.pull(state, (Level)world, pos, null);
            sound.accept(SoundEvents.LEVER_CLICK, Float.valueOf(powered ? 1.3f : 1.5f));
        } else if (block instanceof ControlBox.ControlBoxBlock) {
            BlockEntity te = world.getBlockEntity(pos);
            if (!(te instanceof ControlBox.ControlBoxBlockEntity)) {
                fail.run();
                return;
            }
            ControlBox.ControlBoxBlockEntity rlc = (ControlBox.ControlBoxBlockEntity)te;
            rlc.setEnabled(!rlc.getEnabled());
            sound.accept(SoundEvents.LEVER_CLICK, Float.valueOf(rlc.getEnabled() ? 1.5f : 1.3f));
        } else {
            fail.run();
        }
    }

    private Optional<RemoteData> getRemoteData(ItemStack stack) {
        CompoundTag nbt = Auxiliaries.getItemStackNbt(stack, "remote");
        if (nbt == null || !nbt.contains("pos", 99) || !nbt.contains("name", 8)) {
            return Optional.empty();
        }
        return Optional.of(new RemoteData(BlockPos.of((long)nbt.getLong("pos")), nbt.getString("name")));
    }

    private void setRemoteData(ItemStack stack, BlockPos pos, String name) {
        CompoundTag nbt = new CompoundTag();
        nbt.putLong("pos", pos.asLong());
        nbt.putString("name", name);
        Auxiliaries.setItemStackNbt(stack, "remote", nbt);
    }

    private boolean attack(ItemStack stack, BlockPos pos, Player player) {
        if (!(stack.getItem() instanceof RemoteItem)) {
            return false;
        }
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer splayer = (ServerPlayer)player;
        BlockState state = splayer.serverLevel().getBlockState(pos);
        if (state.getBlock() instanceof LeverBlock || state.getBlock() instanceof ButtonBlock || state.getBlock() instanceof ControlBox.ControlBoxBlock) {
            String name = state.getBlock().getDescriptionId();
            this.setRemoteData(stack, pos, name);
            Overlay.show(splayer, (Component)Auxiliaries.localizable("overlay.remote_saved", pos.getX(), pos.getY(), pos.getZ(), Component.translatable((String)name)), 1500);
        }
        return true;
    }

    private record RemoteData(BlockPos pos, String name) {
    }
}

