/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.items.component.StoredMobVariants;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTags;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AnimalPenVariantHelper {
    public static boolean storeAnimalVariant(ItemStack itemStack, Mob animal, @Nullable Player player) {
        if (AnimalPen.config().getMaxStoredVariants() <= 0) {
            return false;
        }
        StoredMobVariants storedMobVariants = (StoredMobVariants)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get());
        if (storedMobVariants != null && storedMobVariants.variants().size() + 1 > AnimalPen.config().getMaxStoredVariants()) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.too_many_variants").withStyle(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        itemStack.update((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get(), (Object)StoredMobVariants.of(new ArrayList<CompoundTag>(AnimalPen.config().getMaxStoredVariants())), data -> {
            CompoundTag animalTag = new CompoundTag();
            animal.saveWithoutId(animalTag);
            animalTag.remove("Pos");
            animalTag.remove("UUID");
            List<CompoundTag> variants = data.variants();
            variants.add(animalTag);
            return StoredMobVariants.of(variants);
        });
        return true;
    }

    public static Optional<List<CompoundTag>> getAnimalVariants(ItemStack itemStack) {
        if (itemStack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get())) {
            return Optional.of(((StoredMobVariants)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get())).variants());
        }
        return Optional.empty();
    }

    public static boolean canMergeAnimalVariants(ItemStack mainItem, ItemStack redundantItem, @Nullable Player player) {
        if (AnimalPen.config().getMaxStoredVariants() <= 0) {
            return true;
        }
        if (!mainItem.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get()) || !redundantItem.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())) {
            return false;
        }
        StoredMobVariants mainVariants = (StoredMobVariants)mainItem.getOrDefault((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get(), (Object)StoredMobVariants.of(new ArrayList<CompoundTag>()));
        StoredMobVariants redundantVariants = (StoredMobVariants)redundantItem.getOrDefault((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get(), (Object)StoredMobVariants.of(new ArrayList<CompoundTag>()));
        if (mainVariants.variants().size() + redundantVariants.variants().size() > AnimalPen.config().getMaxStoredVariants()) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.too_many_variants").withStyle(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        return true;
    }

    public static void mergeAnimalVariants(ItemStack mainItem, ItemStack redundantItem, @Nullable Player player) {
        if (AnimalPen.config().getMaxStoredVariants() <= 0) {
            return;
        }
        StoredMobVariants mainVariants = (StoredMobVariants)mainItem.getOrDefault((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get(), (Object)StoredMobVariants.of(new ArrayList<CompoundTag>()));
        StoredMobVariants redundantVariants = (StoredMobVariants)redundantItem.getOrDefault((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get(), (Object)StoredMobVariants.of(new ArrayList<CompoundTag>()));
        ArrayList<CompoundTag> mergedList = new ArrayList<CompoundTag>(AnimalPen.config().getMaxStoredVariants());
        mergedList.addAll(mainVariants.variants());
        int remaining = AnimalPen.config().getMaxStoredVariants() - mergedList.size();
        if (remaining > 0) {
            mergedList.addAll(redundantVariants.variants().subList(0, Math.min(remaining, redundantVariants.variants().size())));
        }
        mainItem.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get(), (Object)StoredMobVariants.of(mergedList));
        redundantItem.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get());
    }

    public static boolean customInteraction(EntityType<?> entityType, ItemStack itemStack) {
        return itemStack.is((Item)AnimalPensItemRegistry.ANIMAL_CAGE.get()) && entityType.is(AnimalPenTags.ANIMAL_CAGE_PICKABLE) || itemStack.is((Item)AnimalPensItemRegistry.ANIMAL_CONTAINER.get()) && entityType.is(AnimalPenTags.WATER_MOB_CONTAINER_PICKABLE) || itemStack.is((Item)AnimalPensItemRegistry.BIRD_CATCHER.get()) && entityType.is(AnimalPenTags.BIRD_CATCHER_PICKABLE);
    }
}

