/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.util;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lv.id.bonne.animalpen.items.component.StoredMobData;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;

public class AnimalPenItemHelper {
    public static final Map<DyeColor, ItemLike> ITEM_BY_DYE = (Map)Util.make((Object)Maps.newEnumMap(DyeColor.class), enumMap -> {
        enumMap.put(DyeColor.WHITE, Items.WHITE_WOOL);
        enumMap.put(DyeColor.ORANGE, Items.ORANGE_WOOL);
        enumMap.put(DyeColor.MAGENTA, Items.MAGENTA_WOOL);
        enumMap.put(DyeColor.LIGHT_BLUE, Items.LIGHT_BLUE_WOOL);
        enumMap.put(DyeColor.YELLOW, Items.YELLOW_WOOL);
        enumMap.put(DyeColor.LIME, Items.LIME_WOOL);
        enumMap.put(DyeColor.PINK, Items.PINK_WOOL);
        enumMap.put(DyeColor.GRAY, Items.GRAY_WOOL);
        enumMap.put(DyeColor.LIGHT_GRAY, Items.LIGHT_GRAY_WOOL);
        enumMap.put(DyeColor.CYAN, Items.CYAN_WOOL);
        enumMap.put(DyeColor.PURPLE, Items.PURPLE_WOOL);
        enumMap.put(DyeColor.BLUE, Items.BLUE_WOOL);
        enumMap.put(DyeColor.BROWN, Items.BROWN_WOOL);
        enumMap.put(DyeColor.GREEN, Items.GREEN_WOOL);
        enumMap.put(DyeColor.RED, Items.RED_WOOL);
        enumMap.put(DyeColor.BLACK, Items.BLACK_WOOL);
    });

    public static Optional<SuspiciousStewEffects> getEffectFromItemStack(ItemStack itemStack) {
        BlockItem blockItem;
        Block block;
        Item item = itemStack.getItem();
        if (!(item instanceof BlockItem) || !((block = (blockItem = (BlockItem)item).getBlock()) instanceof FlowerBlock)) {
            return Optional.empty();
        }
        FlowerBlock flowerBlock = (FlowerBlock)block;
        return Optional.of(flowerBlock.getSuspiciousEffects());
    }

    public static ItemStack replacement(ItemStack itemStack) {
        if (itemStack.is(Items.AXOLOTL_BUCKET) || itemStack.is(Items.COD_BUCKET) || itemStack.is(Items.SALMON_BUCKET) || itemStack.is(Items.TROPICAL_FISH_BUCKET) || itemStack.is(Items.PUFFERFISH_BUCKET)) {
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        if (itemStack.is(Items.MILK_BUCKET) || itemStack.is(Items.LAVA_BUCKET) || itemStack.is(Items.WATER_BUCKET) || itemStack.is(Items.POWDER_SNOW_BUCKET)) {
            return new ItemStack((ItemLike)Items.BUCKET);
        }
        return ItemStack.EMPTY;
    }

    public static TagKey<Item> itemTag(ResourceLocation value) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)value);
    }

    public static TagKey<Item> itemTag(String value) {
        return AnimalPenItemHelper.itemTag(ResourceLocation.tryParse((String)value));
    }

    public static Map<String, Integer> getCooldowns(DataComponentHolder componentHolder) {
        return componentHolder.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get()) ? ((StoredMobData)componentHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())).cooldowns() : Collections.emptyMap();
    }

    public static long getMobCount(DataComponentHolder componentHolder) {
        return componentHolder.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get()) ? ((StoredMobData)componentHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())).animalCount() : 0L;
    }
}

