/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.registries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lv.id.bonne.animalpen.interaction.model.AnimalInteraction;
import lv.id.bonne.animalpen.util.AnimalPenItemHelper;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public class AnimalPenInteractionRegistry {
    private static int entityCount;
    private static final Map<ResourceKey<EntityType<?>>, List<AnimalInteraction>> DATA;

    public static void clear() {
        DATA.clear();
    }

    public static void register(ResourceKey<EntityType<?>> id, AnimalInteraction data) {
        DATA.computeIfAbsent(id, loc -> new ArrayList(3)).add(data);
    }

    public static void register(ResourceKey<EntityType<?>> id, List<AnimalInteraction> data) {
        DATA.put(id, data);
    }

    public static List<AnimalInteraction> get(ResourceKey<EntityType<?>> id) {
        return DATA.get(id);
    }

    public static Map<ResourceKey<EntityType<?>>, List<AnimalInteraction>> getAll() {
        return Collections.unmodifiableMap(DATA);
    }

    public static Optional<AnimalInteraction> matchInteraction(Mob mob, DataComponentHolder componentHolder, ItemStack itemInHand) {
        ResourceKey key = (ResourceKey)BuiltInRegistries.ENTITY_TYPE.getResourceKey((Object)mob.getType()).orElseThrow();
        if (!DATA.containsKey(key)) {
            return Optional.empty();
        }
        Map<String, Integer> cooldowns = AnimalPenItemHelper.getCooldowns(componentHolder);
        List<AnimalInteraction> interactions = DATA.get(key);
        return interactions.stream().filter(interaction -> !cooldowns.containsKey(interaction.id())).filter(interaction -> interaction.ingredient().test(itemInHand)).filter(interaction -> interaction.matchAllConditions(componentHolder)).findFirst();
    }

    public static Collection<AnimalInteraction> getInteractions(Mob mob) {
        ResourceKey key = (ResourceKey)BuiltInRegistries.ENTITY_TYPE.getResourceKey((Object)mob.getType()).orElseThrow();
        if (!DATA.containsKey(key)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection((Collection)DATA.get(key));
    }

    public static void setEntityCount(int entityCount) {
        AnimalPenInteractionRegistry.entityCount = entityCount;
    }

    public static boolean containsAllEntities() {
        return DATA.size() == entityCount;
    }

    static {
        DATA = new HashMap();
    }
}

