/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.processing.function.core;

import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interaction.value.Value;
import lv.id.bonne.animalpen.items.component.StoredMobData;
import lv.id.bonne.animalpen.processing.function.api.EntityFunction;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WaterBucketPickup
implements EntityFunction {
    @Override
    public boolean interactPlayer(ServerPlayer player, InteractionHand interactionHand, ItemStack itemConsumed, int amount, Mob mob, ItemStack componentHolder, BlockPos blockPos, String dataKey, Value dataValue) {
        if (!componentHolder.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())) {
            return false;
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.getItem() != Items.WATER_BUCKET || !(mob instanceof Bucketable)) {
            return false;
        }
        Bucketable bucketable = (Bucketable)mob;
        ItemStack bucketItem = bucketable.getBucketItemStack();
        bucketable.saveToBucketTag(bucketItem);
        player.serverLevel().playSound(null, blockPos, bucketable.getPickupSound(), SoundSource.NEUTRAL, 1.0f, Mth.randomBetween((RandomSource)player.serverLevel().getRandom(), (float)0.8f, (float)1.2f));
        player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemInHand, (Player)player, (ItemStack)bucketItem, (boolean)false));
        StoredMobData storedMobData = (StoredMobData)componentHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
        long animalCount = storedMobData.animalCount() - 1L;
        componentHolder.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(animalCount, storedMobData.properties(), storedMobData.cooldowns()));
        if (AnimalPen.config().isTriggerAdvancements()) {
            CriteriaTriggers.FILLED_BUCKET.trigger(player, bucketItem);
        }
        return true;
    }

    @Override
    public boolean interactDispenser(ServerLevel serverLevel, Container dispenserInventory, ItemStack itemConsumed, int amount, Mob mob, ItemStack componentHolder, BlockPos blockPos, String dataKey, Value dataValue) {
        if (!componentHolder.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())) {
            return false;
        }
        if (!itemConsumed.is(Items.WATER_BUCKET) || !(mob instanceof Bucketable)) {
            return false;
        }
        Bucketable bucketable = (Bucketable)mob;
        ItemStack bucketItem = bucketable.getBucketItemStack();
        bucketable.saveToBucketTag(bucketItem);
        serverLevel.playSound(null, blockPos, bucketable.getPickupSound(), SoundSource.NEUTRAL, 1.0f, Mth.randomBetween((RandomSource)serverLevel.getRandom(), (float)0.8f, (float)1.2f));
        Block.popResource((Level)serverLevel, (BlockPos)blockPos, (ItemStack)bucketItem);
        StoredMobData storedMobData = (StoredMobData)componentHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
        long animalCount = storedMobData.animalCount() - 1L;
        componentHolder.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(animalCount, storedMobData.properties(), storedMobData.cooldowns()));
        return true;
    }
}

