/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.processing.function.core;

import lv.id.bonne.animalpen.interaction.value.Value;
import lv.id.bonne.animalpen.items.component.StoredMob;
import lv.id.bonne.animalpen.processing.function.api.EntityFunction;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SheepChangeColor
implements EntityFunction {
    @Override
    public boolean interactPlayer(ServerPlayer player, InteractionHand interactionHand, ItemStack itemConsumed, int amount, Mob mob, ItemStack componentHolder, BlockPos blockPos, String dataKey, Value dataValue) {
        return this.changeSheepColor(itemConsumed, mob, componentHolder);
    }

    @Override
    public boolean interactDispenser(ServerLevel serverLevel, Container container, ItemStack itemConsumed, int amount, Mob mob, ItemStack componentHolder, BlockPos blockPos, String dataKey, Value dataValue) {
        return this.changeSheepColor(itemConsumed, mob, componentHolder);
    }

    private boolean changeSheepColor(ItemStack itemConsumed, Mob mob, ItemStack componentHolder) {
        if (mob instanceof Sheep) {
            Sheep sheep = (Sheep)mob;
            Item item = itemConsumed.getItem();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                sheep.setColor(dye.getDyeColor());
                StoredMob storedMob = (StoredMob)componentHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
                CompoundTag animalTag = new CompoundTag();
                mob.saveWithoutId(animalTag);
                animalTag.remove("UUID");
                animalTag.remove("Pos");
                componentHolder.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get(), (Object)StoredMob.of(storedMob.entityType(), animalTag));
                return true;
            }
        }
        return false;
    }
}

