/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.processing.function.api;

import lv.id.bonne.animalpen.interaction.value.Value;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface EntityFunction {
    default public boolean interactPlayer(ServerPlayer player, InteractionHand interactionHand, ItemStack itemConsumed, int amount, Mob mob, ItemStack componentHolder, BlockPos blockPos, @Nullable String dataKey, @Nullable Value dataValue) {
        return this.processFunction(player.serverLevel(), mob, componentHolder, blockPos, dataKey, dataValue);
    }

    default public boolean interactDispenser(ServerLevel serverLevel, Container dispenserInventory, ItemStack itemConsumed, int amount, Mob mob, ItemStack componentHolder, BlockPos blockPos, @Nullable String dataKey, @Nullable Value dataValue) {
        return this.processFunction(serverLevel, mob, componentHolder, blockPos, dataKey, dataValue);
    }

    default public boolean processFunction(ServerLevel serverLevel, Mob mob, ItemStack componentHolder, BlockPos blockPos, @Nullable String dataKey, @Nullable Value dataValue) {
        return false;
    }

    @FunctionalInterface
    public static interface ProcessEntityFunction
    extends EntityFunction {
        @Override
        public boolean processFunction(ServerLevel var1, Mob var2, ItemStack var3, BlockPos var4, @Nullable String var5, @Nullable Value var6);
    }

    @FunctionalInterface
    public static interface PlayerEntityFunction
    extends EntityFunction {
        @Override
        public boolean interactPlayer(ServerPlayer var1, InteractionHand var2, ItemStack var3, int var4, Mob var5, ItemStack var6, BlockPos var7, @Nullable String var8, @Nullable Value var9);
    }
}

