/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.processing.executor;

import lv.id.bonne.animalpen.blocks.entities.AbstractAnimalPenBlockEntity;
import lv.id.bonne.animalpen.interaction.model.AnimalInteraction;
import lv.id.bonne.animalpen.processing.executor.AnimalInteractionExecutor;
import lv.id.bonne.animalpen.util.AnimalPenItemHelper;
import lv.id.bonne.animalpen.util.ItemTransferUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class DispenserInteractionExecutor
implements AnimalInteractionExecutor {
    private final ServerLevel level;
    private final Container container;
    private final AbstractAnimalPenBlockEntity blockEntity;

    public DispenserInteractionExecutor(ServerLevel level, Container container, AbstractAnimalPenBlockEntity blockEntity) {
        this.level = level;
        this.container = container;
        this.blockEntity = blockEntity;
    }

    @Override
    public int countAvailable(ItemStack item) {
        int count = 0;
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack containerItem = this.container.getItem(i);
            if (!ItemStack.isSameItem((ItemStack)containerItem, (ItemStack)item)) continue;
            count += containerItem.getCount();
        }
        return count;
    }

    @Override
    public void consume(ItemStack consumedItem, int amount) {
        int removed = amount;
        for (int i = 0; i < this.container.getContainerSize() && removed > 0; ++i) {
            ItemStack stack = this.container.getItem(i);
            if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)consumedItem)) continue;
            if (consumedItem.getMaxStackSize() == 1) {
                this.container.setItem(i, AnimalPenItemHelper.replacement(stack));
                --removed;
                continue;
            }
            if (stack.getCount() < removed) {
                removed -= stack.getCount();
                stack = ItemStack.EMPTY;
            } else {
                stack.shrink(removed);
                removed = 0;
            }
            this.container.setItem(i, stack);
        }
    }

    @Override
    public void drop(ItemStack item) {
        ItemTransferUtil.insertBellowOrDrop((Level)this.level, item, this.blockEntity.getBlockPos(), this.blockEntity.dropPosition());
    }

    @Override
    public void damageItem(ItemStack item, int amount) {
        item.hurtAndBreak(amount, this.level, null, damaged -> {});
    }

    @Override
    public ItemStack giveFirst(ItemStack consumedItem, ItemStack lootItem) {
        if (consumedItem.getCount() == 1) {
            ItemStack result = AnimalPenItemHelper.replacement(consumedItem);
            if (result.isEmpty()) {
                consumedItem.shrink(1);
                return lootItem;
            }
            consumedItem.shrink(1);
            this.drop(lootItem);
            return result;
        }
        consumedItem.shrink(1);
        if (!consumedItem.isEmpty()) {
            this.drop(lootItem);
            return consumedItem;
        }
        return lootItem;
    }

    @Override
    public boolean triggerFunctions(AnimalInteraction interaction, ItemStack consumedItem, int consumedAmount, Mob animal, ItemStack componentHolder, BlockPos blockPos) {
        return interaction.triggerFunctions(this.level, this.container, consumedItem, consumedAmount, animal, componentHolder, blockPos);
    }

    @Override
    public void triggerItemUse(Mob animal, ItemStack itemInHand, int consumedAmount) {
    }
}

