/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin;

import java.util.Optional;
import lv.id.bonne.animalpen.blocks.CopperAviaryBlock;
import lv.id.bonne.animalpen.blocks.WeatheringCopperAviary;
import lv.id.bonne.animalpen.registries.AnimalPenBlockRegistry;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LightningBolt.class})
public class MixinLightingBolt {
    @Redirect(method={"randomStepCleaningCopper(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Ljava/util/Optional;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/WeatheringCopper;getPrevious(Lnet/minecraft/world/level/block/state/BlockState;)Ljava/util/Optional;"))
    private static Optional<BlockState> aviaryCleaningStep(BlockState blockState) {
        Optional previous = WeatheringCopper.getPrevious((BlockState)blockState);
        if (previous.isPresent()) {
            return previous;
        }
        return WeatheringCopperAviary.getPrevious(blockState);
    }

    @Redirect(method={"clearCopperOnLightningStrike(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/WeatheringCopper;getFirst(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/state/BlockState;"))
    private static BlockState replaceFirstState(BlockState blockState) {
        if (blockState.getBlock() instanceof CopperAviaryBlock) {
            return ((Block)AnimalPenBlockRegistry.COPPER_AVIARIES.get(WeatheringCopper.WeatherState.UNAFFECTED).get()).withPropertiesOf(blockState);
        }
        return WeatheringCopper.getFirst((BlockState)blockState);
    }
}

