/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.interaction.textentry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import lv.id.bonne.animalpen.interaction.ingredient.CustomIngredient;
import lv.id.bonne.animalpen.interaction.textentry.TextEntryVisibility;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public record TextEntry(String shortMessage, String longMessage, CustomIngredient mainItem, CustomIngredient resultItem, TextEntryVisibility visibility, String[] parameters) {
    public static final Codec<TextEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("short_text", (Object)"").forGetter(TextEntry::shortMessage), (App)Codec.STRING.optionalFieldOf("long_text", (Object)"").forGetter(TextEntry::longMessage), (App)CustomIngredient.CODEC.optionalFieldOf("main_item", (Object)CustomIngredient.EMPTY).forGetter(TextEntry::mainItem), (App)CustomIngredient.CODEC.optionalFieldOf("result_item", (Object)CustomIngredient.EMPTY).forGetter(TextEntry::resultItem), (App)TextEntryVisibility.CODEC.fieldOf("visibility").forGetter(TextEntry::visibility), (App)Codec.STRING.listOf().optionalFieldOf("parameters", Collections.emptyList()).xmap(list -> list.toArray(new String[0]), Arrays::asList).forGetter(TextEntry::parameters)).apply((Applicative)instance, TextEntry::new));
    public static DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    @Nullable
    public Pair<ItemStack[], Component> animalPenGetLine(CustomIngredient item, Map<String, Integer> properties, int tick, boolean shortLine, long cooldown) {
        if (shortLine && this.shortMessage.isBlank() || !shortLine && this.longMessage.isBlank()) {
            return null;
        }
        ChatFormatting color = switch (this.visibility()) {
            default -> throw new MatchException(null, null);
            case TextEntryVisibility.READY -> ChatFormatting.GREEN;
            case TextEntryVisibility.COOLDOWN -> ChatFormatting.WHITE;
            case TextEntryVisibility.NOT_MATCH -> ChatFormatting.GOLD;
            case TextEntryVisibility.ON_MATCH -> ChatFormatting.GOLD;
        };
        Object[] variables = new Object[2 + this.parameters.length];
        variables[0] = Component.translatable((String)"\ue000");
        variables[1] = Component.translatable((String)"\ue001");
        for (int i = 0; i < this.parameters.length; ++i) {
            String format;
            String parameter = this.parameters[i];
            String string = format = parameter.length() <= 2 ? parameter : parameter.substring(1, parameter.length() - 1);
            variables[2 + i] = "[cooldown]".equals(parameter) ? LocalTime.of(0, 0, 0).plusSeconds(cooldown / 20L).format(DATE_FORMATTER) : (properties.containsKey(format) ? properties.get(format) : (format.equals(parameter) ? parameter : ""));
        }
        MutableComponent translatedComponent = Component.translatable((String)(shortLine ? this.shortMessage() : this.longMessage()), (Object[])variables).withStyle(color);
        ItemStack[] resultPair = new ItemStack[]{this.getItemIcon(this.mainItem().isEmpty() ? item.getItems() : this.mainItem().getItems(), tick), this.getItemIcon(this.resultItem().getItems(), tick)};
        return Pair.of((Object)resultPair, (Object)translatedComponent);
    }

    private ItemStack getItemIcon(ItemStack[] items, int tick) {
        return switch (items.length) {
            case 0 -> ItemStack.EMPTY;
            case 1 -> items[0];
            default -> {
                int size = items.length;
                int index = tick / 100 % size;
                yield items[index];
            }
        };
    }

    public static TextEntry ready(String longMessage, CustomIngredient resultItem) {
        return new TextEntry("display.animal_pen.ready", longMessage, CustomIngredient.EMPTY, resultItem, TextEntryVisibility.READY, new String[0]);
    }

    public static TextEntry cooldown(String longMessage, CustomIngredient resultItem) {
        return TextEntry.cooldown(longMessage, CustomIngredient.EMPTY, resultItem);
    }

    public static TextEntry cooldown(String longMessage, CustomIngredient mainItem, CustomIngredient resultItem) {
        return new TextEntry("display.animal_pen.cooldown", longMessage, mainItem, resultItem, TextEntryVisibility.COOLDOWN, "[cooldown]");
    }
}

