/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.interaction.ingredient;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class CustomIngredient
implements Predicate<ItemStack> {
    private final Value[] values;
    @Nullable
    private ItemStack[] itemStacks;
    public static final CustomIngredient EMPTY = new CustomIngredient(Stream.empty());
    public static final Codec<CustomIngredient> CODEC = CustomIngredient.codec();

    private CustomIngredient(Stream<? extends Value> stream) {
        this.values = (Value[])stream.toArray(Value[]::new);
    }

    private CustomIngredient(Value[] values) {
        this.values = values;
    }

    public ItemStack[] getItems() {
        this.dissolve();
        return this.itemStacks;
    }

    private void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(value -> value.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
    }

    @Override
    public boolean test(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        this.dissolve();
        if (this.itemStacks.length == 0) {
            return itemStack.isEmpty();
        }
        return Arrays.stream(this.itemStacks).anyMatch(checkStack -> checkStack.is(itemStack.getItem()));
    }

    public boolean isEmpty() {
        return this.values.length == 0 && (this.itemStacks == null || this.itemStacks.length == 0);
    }

    private static CustomIngredient fromValues(Stream<? extends Value> stream) {
        CustomIngredient ingredient = new CustomIngredient(stream);
        return ingredient.values.length == 0 ? EMPTY : ingredient;
    }

    public static CustomIngredient of() {
        return EMPTY;
    }

    public static CustomIngredient of(ItemLike ... itemLikes) {
        return CustomIngredient.of(Arrays.stream(itemLikes).map(ItemStack::new));
    }

    public static CustomIngredient of(ItemStack ... itemStacks) {
        return CustomIngredient.of(Arrays.stream(itemStacks));
    }

    public static CustomIngredient of(Stream<ItemStack> stream) {
        return CustomIngredient.fromValues(stream.filter(itemStack -> !itemStack.isEmpty()).map(ItemValue::new));
    }

    public static CustomIngredient of(TagKey<Item> tagKey) {
        return CustomIngredient.fromValues(Stream.of(new TagValue(tagKey)));
    }

    public static CustomIngredient merge(CustomIngredient ... ingredients) {
        return CustomIngredient.fromValues(Arrays.stream(ingredients).filter(i -> i != null && i != EMPTY).flatMap(i -> Arrays.stream(i.values)));
    }

    private static Codec<CustomIngredient> codec() {
        Codec codec = Codec.list(Value.CODEC).comapFlatMap(list -> DataResult.success((Object)list.toArray(new Value[0])), List::of);
        return codec.xmap(CustomIngredient::new, i -> i.values);
    }

    static interface Value {
        public static final Codec<Value> CODEC = Codec.STRING.xmap(str -> {
            if (str.startsWith("#")) {
                return new TagValue((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)str.substring(1))));
            }
            return new ItemValue(BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)str)).map(Item::getDefaultInstance).orElse(ItemStack.EMPTY));
        }, value -> {
            if (value instanceof TagValue) {
                TagValue tag = (TagValue)value;
                return "#" + String.valueOf(tag.tag.location());
            }
            if (value instanceof ItemValue) {
                ItemValue val = (ItemValue)value;
                return BuiltInRegistries.ITEM.getKey((Object)val.item.getItem()).toString();
            }
            throw new UnsupportedOperationException("Unknown value type");
        });

        public Collection<ItemStack> getItems();
    }

    static class TagValue
    implements Value {
        private final TagKey<Item> tag;

        TagValue(TagKey<Item> tagKey) {
            this.tag = tagKey;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                list.add(new ItemStack(holder));
            }
            return list;
        }
    }

    static class ItemValue
    implements Value {
        private final ItemStack item;

        ItemValue(ItemStack itemStack) {
            this.item = itemStack;
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }
    }
}

