/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.interaction.condition;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import lv.id.bonne.animalpen.interaction.value.Value;

public enum Operator {
    EQ("="){

        @Override
        public boolean test(Value left, Value right) {
            return left.getAsInt() == right.getAsInt();
        }
    }
    ,
    NE("!="){

        @Override
        public boolean test(Value left, Value right) {
            return left.getAsInt() != right.getAsInt();
        }
    }
    ,
    LT("<"){

        @Override
        public boolean test(Value left, Value right) {
            return left.getAsInt() < right.getAsInt();
        }
    }
    ,
    LTE("<="){

        @Override
        public boolean test(Value left, Value right) {
            return left.getAsInt() <= right.getAsInt();
        }
    }
    ,
    GT(">"){

        @Override
        public boolean test(Value left, Value right) {
            return left.getAsInt() > right.getAsInt();
        }
    }
    ,
    GTE(">="){

        @Override
        public boolean test(Value left, Value right) {
            return left.getAsInt() >= right.getAsInt();
        }
    }
    ,
    MATCH("match"){

        @Override
        public boolean test(Value left, Value right) {
            return left.getAsString().equals(right.getAsString());
        }
    }
    ,
    HAS("has"){

        @Override
        public boolean test(Value left, Value right) {
            return left.getAsBoolean() == right.getAsBoolean();
        }
    };

    private final String token;
    public static final Codec<Operator> CODEC;

    private Operator(String token) {
        this.token = token;
    }

    public abstract boolean test(Value var1, Value var2);

    static {
        CODEC = Codec.STRING.flatXmap(token -> {
            for (Operator op : Operator.values()) {
                if (!op.token.equals(token)) continue;
                return DataResult.success((Object)((Object)op));
            }
            return DataResult.error(() -> "Unknown operator: " + token);
        }, op -> DataResult.success((Object)op.token));
    }
}

