/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.data.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.data.listener.AnimalInteractionEntry;
import lv.id.bonne.animalpen.interaction.condition.ConditionEntry;
import lv.id.bonne.animalpen.interaction.condition.Operator;
import lv.id.bonne.animalpen.interaction.cooldown.CooldownEntry;
import lv.id.bonne.animalpen.interaction.function.FunctionKey;
import lv.id.bonne.animalpen.interaction.ingredient.ConsumerEntry;
import lv.id.bonne.animalpen.interaction.ingredient.CustomIngredient;
import lv.id.bonne.animalpen.interaction.loot.LootEntry;
import lv.id.bonne.animalpen.interaction.model.AnimalInteraction;
import lv.id.bonne.animalpen.interaction.model.AnimalInteractionBuilder;
import lv.id.bonne.animalpen.interaction.textentry.TextEntry;
import lv.id.bonne.animalpen.interaction.textentry.TextEntryVisibility;
import lv.id.bonne.animalpen.interaction.value.BoolValue;
import lv.id.bonne.animalpen.interaction.value.IntValue;
import lv.id.bonne.animalpen.interaction.value.StringValue;
import lv.id.bonne.animalpen.processing.function.wrapper.EntityFunctionEntry;
import lv.id.bonne.animalpen.registries.AnimalPenFunctionRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTags;
import lv.id.bonne.animalpen.util.AnimalPenItemHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.jetbrains.annotations.NotNull;

public class AnimalInteractionProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public AnimalInteractionProvider(PackOutput generator, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.pathProvider = generator.createPathProvider(PackOutput.Target.DATA_PACK, "animal_interactions");
        this.registries = lookupProvider;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(provider -> {
            ArrayList featureList = new ArrayList();
            featureList.add(this.generateAxolotl(cache));
            featureList.add(this.generateBee(cache));
            featureList.add(this.generateChicken(cache));
            featureList.add(this.generateCow(cache));
            featureList.add(this.generateGoat(cache));
            featureList.add(this.generateMooshroom(cache));
            featureList.add(this.generateSheep(cache));
            featureList.add(this.generateTurtle(cache));
            featureList.add(this.generateFrog(cache));
            featureList.add(this.generateAllay(cache));
            featureList.add(this.generateSniffer(cache));
            featureList.add(this.generateArmadillo(cache));
            featureList.add(this.generateFish(cache, EntityType.COD, Items.COD_BUCKET));
            featureList.add(this.generateFish(cache, EntityType.PUFFERFISH, Items.PUFFERFISH_BUCKET));
            featureList.add(this.generateFish(cache, EntityType.SALMON, Items.SALMON_BUCKET));
            featureList.add(this.generateFish(cache, EntityType.TROPICAL_FISH, Items.TROPICAL_FISH_BUCKET));
            featureList.add(this.generateFish(cache, EntityType.TADPOLE, Items.TADPOLE_BUCKET));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.CAT, CustomIngredient.of(AnimalPenItemHelper.itemTag("cat_food")), SoundEvents.CAT_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.DOLPHIN, CustomIngredient.of(AnimalPenItemHelper.itemTag("fishes")), SoundEvents.DOLPHIN_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.FOX, CustomIngredient.of(AnimalPenItemHelper.itemTag("fox_food")), SoundEvents.FOX_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.GLOW_SQUID, CustomIngredient.of(AnimalPenItemHelper.itemTag("fishes")), SoundEvents.GLOW_SQUID_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.HOGLIN, CustomIngredient.of(AnimalPenItemHelper.itemTag("hoglin_food")), SoundEvents.HOGLIN_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.LLAMA, CustomIngredient.of(AnimalPenItemHelper.itemTag("llama_food")), SoundEvents.LLAMA_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.OCELOT, CustomIngredient.of(AnimalPenItemHelper.itemTag("ocelot_food")), SoundEvents.OCELOT_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.PANDA, CustomIngredient.of(AnimalPenItemHelper.itemTag("panda_food")), SoundEvents.PANDA_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.PIG, CustomIngredient.of(AnimalPenItemHelper.itemTag("pig_food")), SoundEvents.PIG_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.RABBIT, CustomIngredient.of(AnimalPenItemHelper.itemTag("rabbit_food")), SoundEvents.RABBIT_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.SQUID, CustomIngredient.of(AnimalPenItemHelper.itemTag("fishes")), SoundEvents.SQUID_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.STRIDER, CustomIngredient.of(AnimalPenItemHelper.itemTag("strider_food")), SoundEvents.STRIDER_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.TRADER_LLAMA, CustomIngredient.of(AnimalPenItemHelper.itemTag("llama_food")), SoundEvents.LLAMA_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.PARROT, CustomIngredient.of(AnimalPenItemHelper.itemTag("parrot_food")), SoundEvents.PARROT_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.WOLF, CustomIngredient.merge(CustomIngredient.of(AnimalPenItemHelper.itemTag("wolf_food"))), SoundEvents.WOLF_AMBIENT));
            CustomIngredient horseFood = CustomIngredient.of(AnimalPenItemHelper.itemTag("horse_food"));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.DONKEY, horseFood, SoundEvents.DONKEY_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.HORSE, horseFood, SoundEvents.HORSE_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.MULE, horseFood, SoundEvents.MULE_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.SKELETON_HORSE, horseFood, SoundEvents.SKELETON_HORSE_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.ZOMBIE_HORSE, horseFood, SoundEvents.ZOMBIE_HORSE_AMBIENT));
            featureList.add(this.generateWithFoodAndAmbient(cache, EntityType.CAMEL, CustomIngredient.of(AnimalPenItemHelper.itemTag("camel_food")), SoundEvents.CAMEL_AMBIENT));
            featureList.add(this.generateAmbient(cache, EntityType.BAT, SoundEvents.BAT_AMBIENT));
            featureList.add(this.generateAmbient(cache, EntityType.POLAR_BEAR, SoundEvents.POLAR_BEAR_AMBIENT));
            return CompletableFuture.allOf((CompletableFuture[])featureList.toArray(CompletableFuture[]::new));
        });
    }

    @NotNull
    public String getName() {
        return "Animal Interactions";
    }

    public AnimalInteraction generateFood(CustomIngredient food, FunctionKey ... finishFunctions) {
        return this.generateFood(food, true, finishFunctions);
    }

    public AnimalInteraction generateFood(CustomIngredient food, boolean stackLimit, FunctionKey ... finishFunctions) {
        return AnimalInteractionBuilder.create("feeding").ingredient(food).even(true).consume(new ConsumerEntry.Consume(stackLimit)).conditions(new ConditionEntry.AmountCondition(Operator.GTE, 2)).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.FEEDING.get())).finishFunctions(finishFunctions).cooldown(new CooldownEntry.Linear(1160, 20, 6000)).textLines(TextEntry.ready("display.animal_pen.food_ready", food)).textLines(TextEntry.cooldown("display.animal_pen.food_cooldown", food)).textLines(new TextEntry("", "display.animal_pen.requires_food", CustomIngredient.EMPTY, food, TextEntryVisibility.NOT_MATCH, "2")).redstoneBit(1).build();
    }

    public AnimalInteraction generateAmbientSound(SoundEvent soundEvent) {
        return AnimalInteractionBuilder.create("ambient").sound(soundEvent.getLocation()).cooldown(new CooldownEntry.Randomized(1200, 6000)).build();
    }

    public CompletableFuture<?> generateAmbient(CachedOutput cache, EntityType<?> entityType, SoundEvent soundEvent) {
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(entityType.builtInRegistryHolder().key(), List.of(this.generateAmbientSound(soundEvent)))).getOrThrow();
        Path file = this.pathProvider.json(entityType.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    public CompletableFuture<?> generateWithFoodAndAmbient(CachedOutput cache, EntityType<?> entityType, CustomIngredient foodItem, SoundEvent soundEvent) {
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(entityType.builtInRegistryHolder().key(), List.of(this.generateFood(foodItem, new FunctionKey[0]), this.generateAmbientSound(soundEvent)))).getOrThrow();
        Path file = this.pathProvider.json(entityType.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateAxolotl(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(3);
        interactions.add(this.generateFood(CustomIngredient.of(AnimalPenItemHelper.itemTag("axolotl_food")), false, new FunctionKey[0]));
        interactions.add(AnimalInteractionBuilder.create("water_bucket_pickup").ingredient(CustomIngredient.of(new ItemLike[]{Items.WATER_BUCKET})).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.WATER_BUCKET_PICKUP.get())).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.AXOLOTL_BUCKET}))).build());
        interactions.add(this.generateAmbientSound(SoundEvents.AXOLOTL_IDLE_WATER));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.AXOLOTL.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.AXOLOTL.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateChicken(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(2);
        interactions.add(this.generateFood(CustomIngredient.of(AnimalPenItemHelper.itemTag("chicken_food")), new FunctionKey[0]));
        interactions.add(AnimalInteractionBuilder.create("eggs").ingredient(CustomIngredient.of(new ItemLike[]{Items.BUCKET})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/bucket/egg"), 80, true)).cooldown(new CooldownEntry.Linear(6000, -20, 200)).sound(SoundEvents.CHICKEN_EGG.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.EGG}))).textLines(TextEntry.cooldown("display.animal_pen.egg_cooldown", CustomIngredient.of(new ItemLike[]{Items.EGG}))).build());
        interactions.add(this.generateAmbientSound(SoundEvents.CHICKEN_AMBIENT));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.CHICKEN.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.CHICKEN.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateBee(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(2);
        interactions.add(this.generateFood(CustomIngredient.of(AnimalPenItemHelper.itemTag("bee_food")), new FunctionKey[0]));
        interactions.add(AnimalInteractionBuilder.create("shearing").ingredient(CustomIngredient.merge(CustomIngredient.of(new ItemLike[]{Items.SHEARS}), CustomIngredient.of(AnimalPenTags.COMMON_SHEARS))).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/shear/honeycomb"))).consume(new ConsumerEntry.Damage(1)).conditions(new ConditionEntry.PropertiesCondition("pollen_level", Operator.GTE, new IntValue(5))).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.INCREMENT_KEY.get(), "pollen_level", -5)).sound(SoundEvents.BEEHIVE_SHEAR.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.HONEYCOMB}))).textLines(new TextEntry("", "display.animal_pen.requires_pollen", CustomIngredient.EMPTY, CustomIngredient.of(new ItemLike[]{Items.HONEYCOMB}), TextEntryVisibility.NOT_MATCH, "5")).build());
        interactions.add(AnimalInteractionBuilder.create("glass_bottle").ingredient(CustomIngredient.of(new ItemLike[]{Items.GLASS_BOTTLE})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/glass_bottle/honey_bottle"))).consume(new ConsumerEntry.Replace()).conditions(new ConditionEntry.PropertiesCondition("pollen_level", Operator.GTE, new IntValue(5))).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.INCREMENT_KEY.get(), "pollen_level", -5)).sound(SoundEvents.BOTTLE_FILL.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.HONEY_BOTTLE}))).textLines(new TextEntry("", "display.animal_pen.requires_pollen", CustomIngredient.EMPTY, CustomIngredient.of(new ItemLike[]{Items.HONEYCOMB}), TextEntryVisibility.NOT_MATCH, "5")).build());
        interactions.add(AnimalInteractionBuilder.create("pollen").sound(SoundEvents.BEEHIVE_WORK.getLocation()).conditions(new ConditionEntry.PropertiesCondition("pollen_level", Operator.LT, new IntValue(10))).finishFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.INCREMENT_KEY.get(), "pollen_level")).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.INCREMENT_KEY.get(), "pollen_level", 0)).cooldown(new CooldownEntry.Linear(1200, -4, 4)).textLines(TextEntry.cooldown("display.animal_pen.pollen_cooldown", CustomIngredient.of(new ItemLike[]{Items.HONEY_BLOCK}), CustomIngredient.of(new ItemLike[]{Items.HONEY_BLOCK}))).textLines(new TextEntry("display.animal_pen.pollen_level", "display.animal_pen.pollen_level", CustomIngredient.of(new ItemLike[]{Items.HONEY_BLOCK}), CustomIngredient.of(new ItemLike[]{Items.HONEY_BLOCK}), TextEntryVisibility.COOLDOWN, "[pollen_level]", "10")).textLines(new TextEntry("display.animal_pen.pollen_level_max", "display.animal_pen.pollen_level_max", CustomIngredient.of(new ItemLike[]{Items.HONEY_BLOCK}), CustomIngredient.of(new ItemLike[]{Items.HONEY_BLOCK}), TextEntryVisibility.NOT_MATCH, "10")).build());
        interactions.add(this.generateAmbientSound(SoundEvents.BEE_POLLINATE));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.BEE.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.BEE.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateCow(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(2);
        interactions.add(this.generateFood(CustomIngredient.of(AnimalPenItemHelper.itemTag("cow_food")), new FunctionKey[0]));
        interactions.add(AnimalInteractionBuilder.create("milk").ingredient(CustomIngredient.of(new ItemLike[]{Items.BUCKET})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/bucket/milk_bucket"))).consume(new ConsumerEntry.Replace()).sound(SoundEvents.COW_MILK.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.MILK_BUCKET}))).textLines(TextEntry.cooldown("display.animal_pen.milk_cooldown", CustomIngredient.of(new ItemLike[]{Items.MILK_BUCKET}))).build());
        interactions.add(this.generateAmbientSound(SoundEvents.COW_AMBIENT));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.COW.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.COW.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateMooshroom(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(2);
        interactions.add(this.generateFood(CustomIngredient.of(AnimalPenItemHelper.itemTag("cow_food")), new FunctionKey[0]));
        interactions.add(AnimalInteractionBuilder.create("milk").ingredient(CustomIngredient.of(new ItemLike[]{Items.BUCKET})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/bucket/milk_bucket"))).consume(new ConsumerEntry.Replace()).sound(SoundEvents.COW_MILK.getLocation()).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.MILK_BUCKET}))).build());
        interactions.add(AnimalInteractionBuilder.create("stew").ingredient(CustomIngredient.of(new ItemLike[]{Items.BOWL})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/bowl/mushroom_stew"))).consume(new ConsumerEntry.Replace()).conditions(new ConditionEntry.MobCondition("stew_effects", Operator.HAS, new BoolValue(false))).sound(SoundEvents.MOOSHROOM_MILK.getLocation()).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.MUSHROOM_STEW}))).build());
        interactions.add(AnimalInteractionBuilder.create("stew").ingredient(CustomIngredient.of(new ItemLike[]{Items.BOWL})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/bowl/suspicious_stew"))).consume(new ConsumerEntry.Replace()).conditions(new ConditionEntry.MobCondition("stew_effects", Operator.HAS, new BoolValue(true))).conditions(new ConditionEntry.MobCondition("Type", Operator.MATCH, new StringValue("brown"))).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.MOOSHROOM_REMOVE_EFFECT.get())).sound(SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY.getLocation()).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.SUSPICIOUS_STEW}))).build());
        interactions.add(AnimalInteractionBuilder.create("flower").ingredient(CustomIngredient.of(AnimalPenItemHelper.itemTag("small_flowers"))).consume(new ConsumerEntry.Replace()).conditions(new ConditionEntry.MobCondition("stew_effects", Operator.HAS, new BoolValue(false))).conditions(new ConditionEntry.MobCondition("Type", Operator.MATCH, new StringValue("brown"))).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.MOOSHROOM_SET_EFFECT.get())).sound(SoundEvents.MOOSHROOM_EAT.getLocation()).textLines(TextEntry.ready("display.animal_pen.apply_ready", CustomIngredient.of(new ItemLike[]{Items.SUSPICIOUS_STEW}))).build());
        interactions.add(AnimalInteractionBuilder.create("flower").ingredient(CustomIngredient.of(AnimalPenItemHelper.itemTag("small_flowers"))).conditions(new ConditionEntry.MobCondition("stew_effects", Operator.HAS, new BoolValue(true))).conditions(new ConditionEntry.MobCondition("Type", Operator.MATCH, new StringValue("brown"))).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.MOOSHROOM_FAILED_EFFECT.get())).build());
        interactions.add(this.generateAmbientSound(SoundEvents.COW_AMBIENT));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.MOOSHROOM.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.MOOSHROOM.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateGoat(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(2);
        interactions.add(this.generateFood(CustomIngredient.of(AnimalPenItemHelper.itemTag("goat_food")), new FunctionKey[0]));
        interactions.add(AnimalInteractionBuilder.create("milk").ingredient(CustomIngredient.of(new ItemLike[]{Items.BUCKET})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/bucket/milk_bucket"))).consume(new ConsumerEntry.Replace()).sound(SoundEvents.GOAT_MILK.getLocation()).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.MILK_BUCKET}))).build());
        interactions.add(this.generateAmbientSound(SoundEvents.GOAT_AMBIENT));
        interactions.add(AnimalInteractionBuilder.create("ambient_screaming").sound(SoundEvents.GOAT_SCREAMING_AMBIENT.getLocation()).cooldown(new CooldownEntry.Randomized(12000, 36000)).build());
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.GOAT.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.GOAT.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateSheep(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(18);
        interactions.add(this.generateFood(CustomIngredient.of(AnimalPenItemHelper.itemTag("sheep_food")), new FunctionKey[0]));
        for (DyeColor value : DyeColor.values()) {
            interactions.add(AnimalInteractionBuilder.create("shearing").ingredient(CustomIngredient.merge(CustomIngredient.of(new ItemLike[]{Items.SHEARS}), CustomIngredient.of(AnimalPenTags.COMMON_SHEARS))).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/shear/wool"), 320, true)).conditions(new ConditionEntry.MobCondition("Color", Operator.EQ, new IntValue(value.getId()))).consume(new ConsumerEntry.Damage(1)).cooldown(new CooldownEntry.Static(1200)).sound(SoundEvents.SHEEP_SHEAR.getLocation()).redstoneBit(2).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.SHEEP_SET_SHEARED.get(), null, true)).finishFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.SHEEP_SET_SHEARED.get(), null, false)).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(AnimalPenItemHelper.ITEM_BY_DYE.get(value)))).textLines(TextEntry.cooldown("display.animal_pen.wool_cooldown", CustomIngredient.of(AnimalPenItemHelper.ITEM_BY_DYE.get(value)))).build());
        }
        interactions.add(AnimalInteractionBuilder.create("dye").ingredient(CustomIngredient.of(new ItemLike[]{Items.WHITE_DYE, Items.ORANGE_DYE, Items.MAGENTA_DYE, Items.LIGHT_BLUE_DYE, Items.YELLOW_DYE, Items.LIME_DYE, Items.PINK_DYE, Items.GRAY_DYE, Items.LIGHT_GRAY_DYE, Items.CYAN_DYE, Items.PURPLE_DYE, Items.BLUE_DYE, Items.BROWN_DYE, Items.GREEN_DYE, Items.RED_DYE, Items.BLACK_DYE})).consume(new ConsumerEntry.Replace()).sound(SoundEvents.DYE_USE.getLocation()).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.SHEEP_CHANGE_COLOR.get())).textLines(TextEntry.ready("display.animal_pen.color_ready", CustomIngredient.of(AnimalPenItemHelper.ITEM_BY_DYE.values().stream().map(ItemStack::new)))).build());
        interactions.add(this.generateAmbientSound(SoundEvents.SHEEP_AMBIENT));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.SHEEP.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.SHEEP.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateTurtle(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(2);
        interactions.add(this.generateFood(CustomIngredient.of(AnimalPenItemHelper.itemTag("turtle_food")), FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.TURTLE_DROP_SCUTE.get())));
        interactions.add(AnimalInteractionBuilder.create("eggs").ingredient(CustomIngredient.of(new ItemLike[]{Items.BUCKET})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/bucket/turtle_egg"), 320, true)).cooldown(new CooldownEntry.Linear(6000, -20, 200)).sound(SoundEvents.TURTLE_LAY_EGG.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.TURTLE_EGG}))).textLines(TextEntry.cooldown("display.animal_pen.egg_cooldown", CustomIngredient.of(new ItemLike[]{Items.TURTLE_EGG}))).build());
        interactions.add(this.generateAmbientSound(SoundEvents.TURTLE_SWIM));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.TURTLE.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.TURTLE.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateFish(CachedOutput cache, EntityType<?> entityType, Item resultItem) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(2);
        if (entityType != EntityType.TADPOLE) {
            interactions.add(this.generateFood(CustomIngredient.of(new ItemLike[]{Items.KELP, Items.SEAGRASS}), new FunctionKey[0]));
        }
        interactions.add(AnimalInteractionBuilder.create("water_bucket_pickup").ingredient(CustomIngredient.of(new ItemLike[]{Items.WATER_BUCKET})).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.WATER_BUCKET_PICKUP.get())).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{resultItem}))).build());
        if (entityType == EntityType.COD) {
            interactions.add(this.generateAmbientSound(SoundEvents.COD_AMBIENT));
        } else if (entityType == EntityType.PUFFERFISH) {
            interactions.add(this.generateAmbientSound(SoundEvents.PUFFER_FISH_AMBIENT));
        } else if (entityType == EntityType.SALMON) {
            interactions.add(this.generateAmbientSound(SoundEvents.SALMON_AMBIENT));
        } else if (entityType == EntityType.TROPICAL_FISH) {
            interactions.add(this.generateAmbientSound(SoundEvents.TROPICAL_FISH_AMBIENT));
        } else if (entityType == EntityType.TADPOLE) {
            interactions.add(this.generateAmbientSound(SoundEvents.TADPOLE_FLOP));
        }
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(entityType.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(entityType.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateFrog(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(5);
        interactions.add(this.generateFood(CustomIngredient.of(AnimalPenItemHelper.itemTag("frog_food")), new FunctionKey[0]));
        interactions.add(AnimalInteractionBuilder.create("froglight").ingredient(CustomIngredient.of(new ItemLike[]{Items.MAGMA_BLOCK})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/magma_cube/froglight"))).consume(new ConsumerEntry.Consume(true)).conditions(new ConditionEntry.MobCondition("variant", Operator.MATCH, new StringValue("minecraft:temperate"))).cooldown(new CooldownEntry.Linear(6000, -20, 200)).sound(SoundEvents.FROG_EAT.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.OCHRE_FROGLIGHT}))).textLines(TextEntry.cooldown("display.animal_pen.frog_light_cooldown", CustomIngredient.of(new ItemLike[]{Items.OCHRE_FROGLIGHT}))).build());
        interactions.add(AnimalInteractionBuilder.create("froglight").ingredient(CustomIngredient.of(new ItemLike[]{Items.MAGMA_BLOCK})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/magma_cube/froglight"))).consume(new ConsumerEntry.Consume(true)).conditions(new ConditionEntry.MobCondition("variant", Operator.MATCH, new StringValue("minecraft:warm"))).cooldown(new CooldownEntry.Linear(6000, -20, 200)).sound(SoundEvents.FROG_EAT.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.PEARLESCENT_FROGLIGHT}))).textLines(TextEntry.cooldown("display.animal_pen.frog_light_cooldown", CustomIngredient.of(new ItemLike[]{Items.PEARLESCENT_FROGLIGHT}))).build());
        interactions.add(AnimalInteractionBuilder.create("froglight").ingredient(CustomIngredient.of(new ItemLike[]{Items.MAGMA_BLOCK})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/magma_cube/froglight"))).consume(new ConsumerEntry.Consume(true)).conditions(new ConditionEntry.MobCondition("variant", Operator.MATCH, new StringValue("minecraft:cold"))).cooldown(new CooldownEntry.Linear(6000, -20, 200)).sound(SoundEvents.FROG_EAT.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.VERDANT_FROGLIGHT}))).textLines(TextEntry.cooldown("display.animal_pen.frog_light_cooldown", CustomIngredient.of(new ItemLike[]{Items.VERDANT_FROGLIGHT}))).build());
        interactions.add(this.generateAmbientSound(SoundEvents.FROG_AMBIENT));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.FROG.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.FROG.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateAllay(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(5);
        CustomIngredient food = CustomIngredient.of(new ItemLike[]{Items.AMETHYST_SHARD});
        interactions.add(AnimalInteractionBuilder.create("feeding").ingredient(food).consume(new ConsumerEntry.Consume(true)).runFunctions(FunctionKey.of((EntityFunctionEntry)AnimalPenFunctionRegistry.DUPLICATE.get())).cooldown(new CooldownEntry.Linear(1160, 20, 6000)).textLines(TextEntry.ready("display.animal_pen.food_ready", food)).textLines(TextEntry.cooldown("display.animal_pen.food_cooldown", food)).sound(SoundEvents.AMETHYST_BLOCK_CHIME.getLocation()).redstoneBit(1).build());
        interactions.add(this.generateAmbientSound(SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.ALLAY.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.ALLAY.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateSniffer(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(2);
        CustomIngredient food = CustomIngredient.of(AnimalPenItemHelper.itemTag("sniffer_food"));
        interactions.add(this.generateFood(food, new FunctionKey[0]));
        interactions.add(AnimalInteractionBuilder.create("eggs").ingredient(CustomIngredient.of(new ItemLike[]{Items.BUCKET})).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/bucket/sniffer_egg"), 320, true)).cooldown(new CooldownEntry.Linear(6000, -20, 200)).sound(SoundEvents.SNIFFER_EGG_PLOP.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.SNIFFER_EGG}))).textLines(TextEntry.cooldown("display.animal_pen.egg_cooldown", CustomIngredient.of(new ItemLike[]{Items.SNIFFER_EGG}))).build());
        interactions.add(AnimalInteractionBuilder.create("sniff").ingredient(CustomIngredient.of(new ItemLike[]{Items.BOWL})).lootEntry(LootEntry.of(BuiltInLootTables.SNIFFER_DIGGING.location(), 320, true)).cooldown(new CooldownEntry.Linear(6000, -20, 200)).consume(new ConsumerEntry.Interact()).sound(SoundEvents.SNIFFER_DIGGING.getLocation()).redstoneBit(3).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.TORCHFLOWER_SEEDS, Items.PITCHER_POD}))).textLines(TextEntry.cooldown("display.animal_pen.sniff_cooldown", CustomIngredient.of(new ItemLike[]{Items.TORCHFLOWER_SEEDS, Items.PITCHER_POD}))).build());
        interactions.add(this.generateAmbientSound(SoundEvents.SNIFFER_IDLE));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.SNIFFER.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.SNIFFER.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }

    private CompletableFuture<?> generateArmadillo(CachedOutput cache) {
        ArrayList<AnimalInteraction> interactions = new ArrayList<AnimalInteraction>(2);
        CustomIngredient food = CustomIngredient.of(AnimalPenItemHelper.itemTag("armadillo_food"));
        interactions.add(this.generateFood(food, new FunctionKey[0]));
        interactions.add(AnimalInteractionBuilder.create("brush").ingredient(CustomIngredient.merge(CustomIngredient.of(new ItemLike[]{Items.BRUSH}), CustomIngredient.of(AnimalPenTags.COMMON_BRUSHES))).lootEntry(LootEntry.of(AnimalPen.resourceOf("animal_interactions/brush/armadillo_scute"))).consume(new ConsumerEntry.Damage(16)).sound(SoundEvents.ARMADILLO_BRUSH.getLocation()).redstoneBit(2).textLines(TextEntry.ready("display.animal_pen.full_ready", CustomIngredient.of(new ItemLike[]{Items.ARMADILLO_SCUTE}))).textLines(TextEntry.cooldown("display.animal_pen.brush_cooldown", CustomIngredient.of(new ItemLike[]{Items.ARMADILLO_SCUTE}))).build());
        interactions.add(this.generateAmbientSound(SoundEvents.ARMADILLO_AMBIENT));
        JsonElement json = (JsonElement)AnimalInteractionEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)AnimalInteractionEntry.of(EntityType.ARMADILLO.builtInRegistryHolder().key(), interactions)).getOrThrow();
        Path file = this.pathProvider.json(EntityType.ARMADILLO.arch$registryName());
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
    }
}

