/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.data.listener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.data.listener.AnimalInteractionEntry;
import lv.id.bonne.animalpen.registries.AnimalPenInteractionRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class AnimalInteractionReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setLenient().create();
    private static final String FOLDER = "animal_interactions";

    public AnimalInteractionReloadListener() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        AnimalPenInteractionRegistry.clear();
        jsonMap.forEach((id, element) -> {
            DataResult result = AnimalInteractionEntry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, element);
            AnimalInteractionEntry data = (AnimalInteractionEntry)result.getOrThrow(message -> {
                AnimalPen.LOGGER.error("Failed to parse animal interaction entry from {}: {}", id, message);
                return null;
            });
            data.interactions().forEach(animalInteraction -> AnimalPenInteractionRegistry.register(data.entityType().get(), animalInteraction));
        });
        AnimalPen.LOGGER.info("Loaded " + AnimalPenInteractionRegistry.getAll().size() + " animal interaction entries.");
    }
}

