/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.data.listener;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import dev.architectury.platform.Platform;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lv.id.bonne.animalpen.interaction.model.AnimalInteraction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;

public record AnimalInteractionEntry(Optional<ResourceKey<EntityType<?>>> entityType, List<String> requiredMods, List<AnimalInteraction> interactions) {
    private static final AnimalInteractionEntry EMPTY = new AnimalInteractionEntry(Optional.empty(), Collections.emptyList(), Collections.emptyList());
    public static final Codec<ResourceKey<EntityType<?>>> ENTITY_KEY_CODEC = ResourceKey.codec((ResourceKey)Registries.ENTITY_TYPE);
    public static final Codec<AnimalInteractionEntry> CODEC = new Codec<AnimalInteractionEntry>(){

        public <T> DataResult<Pair<AnimalInteractionEntry, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).flatMap(map -> {
                List requiredMods = map.get("required_mods") != null ? Codec.STRING.listOf().parse(ops, map.get("required_mods")).result().orElse(List.of()) : List.of();
                boolean modsPresent = requiredMods.stream().allMatch(Platform::isModLoaded);
                if (!modsPresent) {
                    return DataResult.success((Object)Pair.of((Object)EMPTY, (Object)input));
                }
                DataResult entityResult = ENTITY_KEY_CODEC.parse(ops, map.get("entity"));
                DataResult interactionsResult = map.get("interactions") != null ? AnimalInteraction.CODEC.listOf().parse(ops, map.get("interactions")) : DataResult.success(List.of());
                return entityResult.flatMap(entity -> interactionsResult.map(interactions -> Pair.of((Object)new AnimalInteractionEntry(Optional.of(entity), requiredMods, (List<AnimalInteraction>)interactions), (Object)input)));
            });
        }

        public <T> DataResult<T> encode(AnimalInteractionEntry value, DynamicOps<T> ops, T prefix) {
            RecordBuilder builder = ops.mapBuilder();
            if (value.entityType().isEmpty()) {
                return DataResult.error(() -> "Cannot encode given value as entity type is missing: " + prefix.toString());
            }
            if (!value.requiredMods().isEmpty()) {
                builder.add("required_mods", Codec.STRING.listOf().encodeStart(ops, value.requiredMods()));
            }
            builder.add("entity", ENTITY_KEY_CODEC.encodeStart(ops, value.entityType().get()));
            builder.add("interactions", AnimalInteraction.CODEC.listOf().encodeStart(ops, value.interactions()));
            return builder.build(prefix);
        }
    };

    public boolean isActive() {
        return this.entityType.isPresent() && !this.interactions.isEmpty();
    }

    public static AnimalInteractionEntry of(ResourceKey<EntityType<?>> entityType, List<AnimalInteraction> animalInteractions) {
        return new AnimalInteractionEntry(Optional.of(entityType), Collections.emptyList(), animalInteractions);
    }
}

