/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.config.Configuration;
import lv.id.bonne.animalpen.config.util.CommentGeneration;

public class ConfigurationManager {
    private final Gson gson;
    private Configuration configuration;

    public ConfigurationManager() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public void generateConfig() {
        this.reset();
        try {
            this.writeConfig(true);
        }
        catch (IOException e) {
            AnimalPen.LOGGER.error("Error Generating config file: ", (Throwable)e);
        }
    }

    private File getConfigFile() {
        return new File("config/animal_pen_config.json");
    }

    public void readConfig() {
        try (FileReader reader = new FileReader(this.getConfigFile());){
            this.configuration = (Configuration)this.gson.fromJson((Reader)reader, Configuration.class);
            if (this.isInvalid()) {
                if (this.configuration == null) {
                    this.configuration = new Configuration();
                }
                this.configuration.setDefaults(false);
                this.writeConfig(false);
            }
        }
        catch (JsonSyntaxException var2) {
            this.reset();
            try {
                this.writeConfig(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            AnimalPen.LOGGER.error("Failed to read config. Generated default one.");
        }
        catch (IOException var2) {
            this.generateConfig();
            AnimalPen.LOGGER.error("Failed to open config. Generated default one.");
        }
    }

    public void reloadConfig() {
        try (FileReader reader = new FileReader(this.getConfigFile());){
            this.configuration = (Configuration)this.gson.fromJson((Reader)reader, Configuration.class);
            if (this.isInvalid()) {
                AnimalPen.LOGGER.error("Failed to validate config.");
            }
        }
        catch (IOException var2) {
            AnimalPen.LOGGER.error("Failed to read config. " + var2.getMessage());
        }
    }

    protected void reset() {
        this.configuration = Configuration.getDefaultConfig();
    }

    private boolean isInvalid() {
        return this.configuration == null || this.configuration.isInvalid();
    }

    public void writeConfig(boolean overwrite) throws IOException {
        File dir = new File("config/");
        if (dir.exists() || dir.mkdirs()) {
            if (this.getConfigFile().exists() && !overwrite) {
                File backupFile;
                int backupNumber = 1;
                do {
                    backupFile = new File(dir, this.getConfigFile().getName() + ".bak" + backupNumber);
                    ++backupNumber;
                } while (backupFile.exists());
                Files.copy(this.getConfigFile().toPath(), backupFile.toPath(), new CopyOption[0]);
            }
            if (this.getConfigFile().exists() || this.getConfigFile().createNewFile()) {
                try {
                    Path path = Paths.get(this.getConfigFile().toURI());
                    Files.write(path, CommentGeneration.writeWithComments(this.gson, this.configuration).getBytes(), new OpenOption[0]);
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

