/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.config;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import lv.id.bonne.animalpen.config.annotations.JsonComment;
import lv.id.bonne.animalpen.config.annotations.JsonComments;

public class Configuration {
    @JsonComments(value={@JsonComment(value="A cooldown value in game ticks between attacks that players can perform on animal pens."), @JsonComment(value="Default value: 5 game tick")})
    @Expose
    @SerializedName(value="attack_cooldown")
    private Integer attackCooldown;
    @JsonComments(value={@JsonComment(value="Allows to set maximal amount of animals in the pen."), @JsonComment(value="Setting 0 will remove any limit.")})
    @Expose
    @SerializedName(value="animal_limit_in_pen")
    private long maximalAnimalCount = Integer.MAX_VALUE;
    @JsonComments(value={@JsonComment(value="Allows to enable mob growing in animal pen."), @JsonComment(value="The more animals are inside it, the larger it will be.")})
    @Expose
    @SerializedName(value="animal_pen_mob_can_grow", alternate={"animals_can_grow"})
    private boolean growAnimalPenMob = false;
    @JsonComment(value="Allows to change default mob size in pen.")
    @Expose
    @SerializedName(value="animal_pen_mob_size", alternate={"animal_size"})
    private Float animalPenMobSize;
    @JsonComments(value={@JsonComment(value="Allows to enable aquarium mob growing."), @JsonComment(value="The more animals are inside it, the larger it will be.")})
    @Expose
    @SerializedName(value="aquarium_mob_can_grow", alternate={"water_animals_can_grow"})
    private boolean growAquariumMob = false;
    @JsonComment(value="Allows to change default mob size in aquarium.")
    @Expose
    @SerializedName(value="aquarium_mob_size", alternate={"water_animal_size"})
    private Float aquariumMobSize;
    @JsonComments(value={@JsonComment(value="Allows to enable aviary mobs growing."), @JsonComment(value="The more mobs are inside it, the larger it will be.")})
    @Expose
    @SerializedName(value="aviary_mob_can_grow")
    private Boolean growAviaryMob = false;
    @JsonComment(value="Allows to change default mob size in aviary.")
    @Expose
    @SerializedName(value="aviary_mob_size")
    private Float aviaryMobSize;
    @JsonComments(value={@JsonComment(value="Allows to set how fast animals grows in pen and aquarium."), @JsonComment(value="Each animal is multiplied by given value to get end size."), @JsonComment(value="This option works only if animals_can_grow or water_animals_can_grow is enabled."), @JsonComment(value="Default value = 0.001")})
    @Expose
    @SerializedName(value="growth_multiplier")
    private Float growthMultiplier;
    @JsonComments(value={@JsonComment(value="Allows to set how many different animal variants can be stored per item."), @JsonComment(value="Players will not be able to store more different variants than this value."), @JsonComment(value="Be aware, this increases NBT data size, so not recommended to put infinite amount."), @JsonComment(value="Default value = 16")})
    @Expose
    @SerializedName(value="max_stored_animal_variants")
    private Integer maxStoredAnimalVariants;
    @JsonComments(value={@JsonComment(value="Allows to set if interactions with animal pens/aquariums should trigger advancements."), @JsonComment(value="Triggered Criteria: player_interacted_with_entity, bred_animals, filled_bucket, player_killed_entity"), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="trigger_advancements")
    private Boolean triggerAdvancements;
    @JsonComments(value={@JsonComment(value="Allows to set if interactions with animal pens/aquariums should increase statistics."), @JsonComment(value="Increased Statistics: Animals Bred, Mob Kills, Use Item <item>, Kill Entity <entity>"), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="increase_statistics")
    private Boolean increaseStatistics;
    @JsonComments(value={@JsonComment(value="Allows to toggle if cooldowns should be shown only while player is crouching (true)."), @JsonComment(value="or be visible all the time (false)."), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="show_cooldowns_while_crouching")
    private Boolean showCooldownsOnCrouch;
    @JsonComments(value={@JsonComment(value="Allows to toggle if all interactions (evenNumber without cooldown) should be rendered"), @JsonComment(value="above animal pen or aquarium"), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="show_all_interactions_above")
    private Boolean showAllInteractions;
    @JsonComment(value="Debug code to indicate problems.")
    @Expose
    @SerializedName(value="debug")
    private Boolean debug;

    public boolean isInvalid() {
        return this.aquariumMobSize == null || this.aquariumMobSize.floatValue() <= 0.0f || this.animalPenMobSize == null || this.animalPenMobSize.floatValue() <= 0.0f || this.growthMultiplier == null || this.growthMultiplier.floatValue() < 0.0f || this.attackCooldown == null || this.attackCooldown < 0 || this.maxStoredAnimalVariants == null || this.triggerAdvancements == null || this.increaseStatistics == null || this.maxStoredAnimalVariants < 0 || this.debug == null || this.showAllInteractions == null || this.showCooldownsOnCrouch == null || this.growAviaryMob == null || this.aviaryMobSize == null || this.aviaryMobSize.floatValue() <= 0.0f;
    }

    public void setDefaults(boolean init) {
        if (this.animalPenMobSize == null || this.animalPenMobSize.floatValue() <= 0.0f || init) {
            this.animalPenMobSize = Float.valueOf(0.33f);
        }
        if (this.aquariumMobSize == null || this.aquariumMobSize.floatValue() <= 0.0f || init) {
            this.aquariumMobSize = Float.valueOf(0.33f);
        }
        if (this.aviaryMobSize == null || this.aviaryMobSize.floatValue() <= 0.0f || init) {
            this.aviaryMobSize = Float.valueOf(0.33f);
        }
        if (this.growAviaryMob == null || init) {
            this.growAviaryMob = false;
        }
        if (this.growthMultiplier == null || this.growthMultiplier.floatValue() < 0.0f || init) {
            this.growthMultiplier = Float.valueOf(0.001f);
        }
        if (this.attackCooldown == null || this.attackCooldown < 0 || init) {
            this.attackCooldown = 5;
        }
        if (this.maxStoredAnimalVariants == null || this.maxStoredAnimalVariants < 0 || init) {
            this.maxStoredAnimalVariants = 16;
        }
        if (this.increaseStatistics == null || init) {
            this.increaseStatistics = false;
        }
        if (this.triggerAdvancements == null || init) {
            this.triggerAdvancements = false;
        }
        if (this.debug == null || init) {
            this.debug = false;
        }
        if (this.showAllInteractions == null || init) {
            this.showAllInteractions = false;
        }
        if (this.showCooldownsOnCrouch == null || init) {
            this.showCooldownsOnCrouch = false;
        }
        if (init) {
            this.maximalAnimalCount = Integer.MAX_VALUE;
            this.growAnimalPenMob = false;
            this.growAquariumMob = false;
        }
    }

    public long getMaximalAnimalCount() {
        return this.maximalAnimalCount;
    }

    public boolean isGrowAnimalPenMob() {
        return this.growAnimalPenMob;
    }

    public float getAnimalPenMobSize() {
        return this.animalPenMobSize.floatValue();
    }

    public boolean isGrowAquariumMob() {
        return this.growAquariumMob;
    }

    public float getAquariumMobSize() {
        return this.aquariumMobSize.floatValue();
    }

    public boolean isGrowAviaryMob() {
        return this.growAviaryMob;
    }

    public float getAviaryMobSize() {
        return this.aviaryMobSize.floatValue();
    }

    public Float getGrowthMultiplier() {
        return this.growthMultiplier;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public int getMaxStoredVariants() {
        return this.maxStoredAnimalVariants;
    }

    public boolean isTriggerAdvancements() {
        return this.triggerAdvancements;
    }

    public boolean isIncreaseStatistics() {
        return this.increaseStatistics;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isShowCooldownsOnCrouch() {
        return this.showCooldownsOnCrouch;
    }

    public boolean isShowAllInteractions() {
        return this.showAllInteractions;
    }

    public static Configuration getDefaultConfig() {
        Configuration configuration = new Configuration();
        configuration.setDefaults(true);
        return configuration;
    }

    public void setGrowAnimalPenMob(boolean growAnimalPenMob) {
        this.growAnimalPenMob = growAnimalPenMob;
    }

    public void setAnimalPenMobSize(float animalPenMobSize) {
        this.animalPenMobSize = Float.valueOf(animalPenMobSize);
    }

    public void setGrowAquariumMob(boolean growAquariumMob) {
        this.growAquariumMob = growAquariumMob;
    }

    public void setAquariumMobSize(float aquariumMobSize) {
        this.aquariumMobSize = Float.valueOf(aquariumMobSize);
    }

    public void setGrowAviaryMob(boolean growAviaryMob) {
        this.growAviaryMob = growAviaryMob;
    }

    public void setAviaryMobSize(float aviaryMobSize) {
        this.aviaryMobSize = Float.valueOf(aviaryMobSize);
    }

    public void setGrowthMultiplier(float growthMultiplier) {
        this.growthMultiplier = Float.valueOf(growthMultiplier);
    }

    public void setShowCooldownsOnCrouch(boolean showCooldownsOnCrouch) {
        this.showCooldownsOnCrouch = showCooldownsOnCrouch;
    }

    public void setShowAllInteractions(boolean showAllInteractions) {
        this.showAllInteractions = showAllInteractions;
    }

    public void setAttackCooldown(Integer attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public void setMaximalAnimalCount(long maximalAnimalCount) {
        this.maximalAnimalCount = maximalAnimalCount;
    }

    public void setMaxStoredAnimalVariants(Integer maxStoredAnimalVariants) {
        this.maxStoredAnimalVariants = maxStoredAnimalVariants;
    }

    public void setTriggerAdvancements(Boolean triggerAdvancements) {
        this.triggerAdvancements = triggerAdvancements;
    }

    public void setIncreaseStatistics(Boolean increaseStatistics) {
        this.increaseStatistics = increaseStatistics;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }
}

