/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.function.Supplier;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AbstractAnimalPenBlockEntity;
import lv.id.bonne.animalpen.blocks.renderer.AnimalPenRenderer;
import lv.id.bonne.animalpen.blocks.renderer.AquariumRenderer;
import lv.id.bonne.animalpen.blocks.renderer.AviaryRenderer;
import lv.id.bonne.animalpen.client.WaterTankColor;
import lv.id.bonne.animalpen.client.screens.VariantScreenSelection;
import lv.id.bonne.animalpen.network.packets.AnimalInteractionSyncEndPacket;
import lv.id.bonne.animalpen.network.packets.AnimalInteractionSyncEntityPacket;
import lv.id.bonne.animalpen.network.packets.AnimalInteractionSyncStartPacket;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenBlockRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class AnimalPenClient {
    public static void init() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get()), context -> new AnimalPenRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)AnimalPenTileEntityRegistry.AQUARIUM_TILE_ENTITY.get()), context -> new AquariumRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)AnimalPenTileEntityRegistry.AVIARY_TILE_ENTITY.get()), context -> new AviaryRenderer());
        RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)AnimalPenBlockRegistry.AQUARIUM.get()});
        RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)AnimalPenBlockRegistry.AVIARY.get()});
        RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)AnimalPenBlockRegistry.GOLD_AVIARY.get()});
        AnimalPenBlockRegistry.COPPER_AVIARIES.values().forEach(aviary -> RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)aviary.get()}));
        AnimalPenBlockRegistry.WAXED_COPPER_AVIARIES.values().forEach(copperAviary -> RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)copperAviary.get()}));
        ItemPropertiesRegistry.registerGeneric((ResourceLocation)AnimalPen.resourceOf("filled_cage"), (itemStack, clientLevel, livingEntity, i) -> itemStack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get()) ? 1.0f : 0.0f);
        ColorHandlerRegistry.registerBlockColors((BlockColor)new WaterTankColor(), (Supplier[])new Supplier[]{AnimalPenBlockRegistry.AQUARIUM});
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, interactionHand, blockPos, direction) -> {
            if (Minecraft.getInstance().player != player) {
                return EventResult.pass();
            }
            BlockEntity patt0$temp = player.level().getBlockEntity(blockPos);
            if (!(patt0$temp instanceof AbstractAnimalPenBlockEntity)) {
                return EventResult.pass();
            }
            AbstractAnimalPenBlockEntity blockEntity = (AbstractAnimalPenBlockEntity)patt0$temp;
            if (!player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() || player.isCrouching()) {
                return EventResult.pass();
            }
            if (blockEntity.getStoredAnimal().isEmpty()) {
                return EventResult.pass();
            }
            if (PlayerHooks.isFake((Player)player)) {
                return EventResult.pass();
            }
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen((Screen)new VariantScreenSelection(blockPos)));
            return EventResult.interruptTrue();
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, AnimalInteractionSyncStartPacket.ID, AnimalInteractionSyncStartPacket.STREAM_CODEC, AnimalInteractionSyncStartPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, AnimalInteractionSyncEntityPacket.ID, AnimalInteractionSyncEntityPacket.STREAM_CODEC, AnimalInteractionSyncEntityPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, AnimalInteractionSyncEndPacket.ID, AnimalInteractionSyncEndPacket.STREAM_CODEC, AnimalInteractionSyncEndPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, UpdateVariantScreenData.ID, UpdateVariantScreenData.STREAM_CODEC, UpdateVariantScreenData::handle);
    }
}

