/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.renderer;

import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AviaryTileEntity;
import lv.id.bonne.animalpen.blocks.renderer.AbstractAnimalPenRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class AviaryRenderer
extends AbstractAnimalPenRenderer<AviaryTileEntity> {
    @Override
    protected float getAnimalVerticalOffset() {
        return 0.5f;
    }

    @Override
    protected float getAnimalSize() {
        return AnimalPen.config().getAviaryMobSize();
    }

    @Override
    protected boolean shouldGrowAnimals() {
        return AnimalPen.config().isGrowAviaryMob();
    }

    @Override
    protected double getTextStartHeight() {
        return 1.5;
    }

    public boolean shouldRenderOffScreen(AviaryTileEntity blockEntity) {
        return !blockEntity.getInventory().isEmpty() && AnimalPen.config().isGrowAviaryMob();
    }

    public boolean shouldRender(AviaryTileEntity blockEntity, Vec3 vec3) {
        return AnimalPen.config().isGrowAviaryMob() || super.shouldRender((BlockEntity)blockEntity, vec3);
    }

    @Override
    protected void configureAnimalPose(Mob animal, AviaryTileEntity tileEntity) {
        super.configureAnimalPose(animal, tileEntity);
        animal.setOnGround(false);
        if (animal.tickCount == tileEntity.getTickCounter()) {
            return;
        }
        if (animal instanceof Parrot) {
            Parrot parrot = (Parrot)animal;
            parrot.oFlap = parrot.flap;
            parrot.oFlapSpeed = parrot.flapSpeed;
            parrot.flapSpeed += 1.2f;
            parrot.flapSpeed = Mth.clamp((float)parrot.flapSpeed, (float)0.0f, (float)1.0f);
            parrot.flap += 1.8f;
        } else if (animal instanceof Bat) {
            Bat bat = (Bat)animal;
            bat.flyAnimationState.startIfStopped(bat.tickCount);
        }
    }
}

