/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interaction.function.FunctionKey;
import lv.id.bonne.animalpen.interaction.ingredient.ConsumerEntry;
import lv.id.bonne.animalpen.interaction.model.AnimalInteraction;
import lv.id.bonne.animalpen.interaction.textentry.TextEntryVisibility;
import lv.id.bonne.animalpen.items.component.StoredMob;
import lv.id.bonne.animalpen.items.component.StoredMobData;
import lv.id.bonne.animalpen.items.component.StoredMobVariants;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.processing.executor.AnimalInteractionExecutor;
import lv.id.bonne.animalpen.processing.executor.DispenserInteractionExecutor;
import lv.id.bonne.animalpen.processing.executor.PlayerInteractionExecutor;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenInteractionRegistry;
import lv.id.bonne.animalpen.util.AnimalPenItemHelper;
import lv.id.bonne.animalpen.util.AnimalPenVariantHelper;
import lv.id.bonne.animalpen.util.ItemTransferUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAnimalPenBlockEntity
extends BlockEntity {
    private final List<Integer> deathTicker = new ArrayList<Integer>();
    private Mob storedAnimal;
    private final SimpleContainer inventory = new SimpleContainer(1){

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return AbstractAnimalPenBlockEntity.this.validateItemStack(stack);
        }

        public void fromTag(ListTag listTag, HolderLookup.Provider provider) {
            this.clearContent();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag tag = listTag.getCompound(i);
                ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag).ifPresent(itemStack -> {
                    if (tag.contains("tag")) {
                        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag.getCompound("tag")));
                    }
                    this.addItem((ItemStack)itemStack);
                });
            }
        }

        public void setChanged() {
            super.setChanged();
        }
    };
    private long displaySize = -1L;
    private UUID ownerUUID;
    private long protectedAmount = 0L;
    private int tickCounter;

    public AbstractAnimalPenBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("inventory", (Tag)this.inventory.createTag(provider));
        tag.put("death_ticker", (Tag)new IntArrayTag(this.deathTicker));
        tag.putLong("display_size", this.displaySize);
        this.getOwner().ifPresent(owner -> tag.putUUID("owner_uuid", owner));
        tag.putLong("keep_amount", this.protectedAmount);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.clearContent();
        this.deathTicker.clear();
        if (tag.contains("inventory", 9)) {
            this.inventory.fromTag(tag.getList("inventory", 10), provider);
        }
        if (tag.contains("death_ticker", 11)) {
            int[] intArray;
            for (int i : intArray = tag.getIntArray("death_ticker")) {
                this.deathTicker.add(i);
            }
        }
        this.displaySize = tag.contains("display_size", 4) ? tag.getLong("display_size") : -1L;
        if (tag.contains("owner_uuid")) {
            this.ownerUUID = tag.getUUID("owner_uuid");
        }
        this.protectedAmount = tag.getLong("keep_amount");
        if (this.getItemStack().isEmpty()) {
            this.storedAnimal = null;
        } else if (this.storedAnimal != null && this.level != null && this.level.isClientSide()) {
            StoredMob storedMob = (StoredMob)this.getItemStack().get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
            this.storedAnimal.load(storedMob.tag());
        }
        this.setChanged();
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void triggerUpdate() {
        this.setChanged();
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public void tick() {
        ++this.tickCounter;
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        boolean updated = this.getStoredAnimal().map(animal -> {
            Map<String, Integer> cooldowns = AnimalPenItemHelper.getCooldowns((DataComponentHolder)this.getItemStack());
            boolean cooldownChange = false;
            HashSet<String> allKeys = new HashSet<String>(cooldowns.keySet());
            for (String key : allKeys) {
                int time = cooldowns.get(key);
                if (--time > 0) {
                    cooldowns.put(key, time);
                } else {
                    cooldowns.remove(key);
                    this.triggerEndFunctions((ServerLevel)this.getLevel(), (Mob)animal, this.getItemStack(), key);
                }
                cooldownChange |= this.requiresClientUpdate((Mob)animal, key);
            }
            this.getItemStack().update((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.EMPTY, data -> StoredMobData.of(data.animalCount(), data.properties(), cooldowns));
            return cooldownChange |= this.triggerStartFunctions((ServerLevel)this.getLevel(), (Mob)animal, this.getItemStack(), cooldowns);
        }).orElse(false);
        for (int i = 0; i < this.deathTicker.size(); ++i) {
            this.deathTicker.set(i, this.deathTicker.get(i) + 1);
            updated = true;
        }
        this.deathTicker.removeIf(integer -> integer > 20);
        if (updated) {
            this.triggerUpdate();
        }
    }

    public boolean processContainer(Player player, InteractionHand interactionHand) {
        if (interactionHand != InteractionHand.MAIN_HAND) {
            return false;
        }
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.getUUID())) {
            AnimalPen.sendDebug("Protection is enabled");
            return false;
        }
        if (this.inventory.isEmpty()) {
            ItemStack itemInHand = player.getItemInHand(interactionHand);
            if (!itemInHand.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())) {
                return false;
            }
            if (!player.level().isClientSide()) {
                this.inventory.addItem(itemInHand);
                player.setItemInHand(interactionHand, ItemStack.EMPTY);
                this.triggerUpdate();
                if (this.level != null && !this.level.isClientSide()) {
                    NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
                }
                AnimalPen.sendDebug("Deposit animal cage into pen");
            }
            return true;
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (!itemInHand.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())) {
            if (!player.isCrouching()) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            Mob animal = this.getStoredAnimal().orElse(null);
            if (animal == null) {
                return false;
            }
            long currentCount = this.getAnimalCount();
            if (currentCount < 2L) {
                AnimalPen.sendDebug("Cannot split 1");
                return false;
            }
            long newCount = Math.min(currentCount - this.protectedAmount, currentCount / 2L);
            if (newCount <= 0L) {
                AnimalPen.sendDebug("Protected amount prevents from splitting");
                return false;
            }
            if (!this.updateAnimalCount(-newCount)) {
                AnimalPen.sendDebug("Fail to reduce animal count");
                return false;
            }
            itemInHand.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get(), (Object)((StoredMob)this.getItemStack().get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())));
            itemInHand.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)new StoredMobData(newCount, new HashMap<String, Integer>(0), AnimalPenItemHelper.getCooldowns((DataComponentHolder)this.getItemStack())));
            this.triggerUpdate();
            AnimalPen.sendDebug("Half the amount of animals in pen");
            return true;
        }
        Mob animal = this.getStoredAnimal().orElse(null);
        StoredMob storedMob = (StoredMob)itemInHand.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
        if (animal == null || !animal.getType().equals(storedMob.entityType())) {
            AnimalPen.sendDebug("Different animals");
            return false;
        }
        if (player.level().isClientSide()) {
            return true;
        }
        long newCount = AnimalPenItemHelper.getMobCount((DataComponentHolder)itemInHand);
        if (newCount <= 0L || !this.updateAnimalCount(newCount)) {
            AnimalPen.sendDebug("Failed to deposit animal");
            return false;
        }
        if (newCount > 1L && !AnimalPenVariantHelper.canMergeAnimalVariants(this.getItemStack(), itemInHand, player)) {
            AnimalPen.sendDebug("Variants could not be merged");
            this.updateAnimalCount(-1L);
            itemInHand.update((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.EMPTY, data -> StoredMobData.of(1L, data.properties(), data.cooldowns()));
        } else {
            AnimalPenVariantHelper.mergeAnimalVariants(this.getItemStack(), itemInHand, player);
            itemInHand.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
            StoredMobData removedData = (StoredMobData)itemInHand.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
            itemInHand.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get());
            if (removedData != null && !removedData.cooldowns().isEmpty()) {
                Map<String, Integer> cooldowns = AnimalPenItemHelper.getCooldowns((DataComponentHolder)this.getItemStack());
                removedData.cooldowns().forEach((key, value) -> cooldowns.put((String)key, Math.max(value, cooldowns.getOrDefault(key, 0))));
                this.getItemStack().update((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.EMPTY, data -> StoredMobData.of(data.animalCount(), data.properties(), cooldowns));
            }
            if (this.level != null && !this.level.isClientSide()) {
                NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
            }
        }
        player.setItemInHand(interactionHand, itemInHand);
        this.triggerUpdate();
        AnimalPen.sendDebug("Cage merged into pen");
        return true;
    }

    public boolean interactWithPen(Player player, InteractionHand interactionHand) {
        ServerLevel serverLevel;
        ItemStack itemInHand;
        block7: {
            block6: {
                if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.getUUID())) {
                    AnimalPen.sendDebug("Protection is enabled");
                    return false;
                }
                itemInHand = player.getItemInHand(interactionHand);
                if (itemInHand.isEmpty() && !this.inventory.isEmpty()) {
                    if (player.isCrouching() && !player.level().isClientSide()) {
                        ItemStack item = this.getItemStack();
                        player.setItemInHand(interactionHand, item);
                        this.inventory.setItem(0, ItemStack.EMPTY);
                        this.triggerUpdate();
                        AnimalPen.sendDebug("Taking out animal cage");
                    }
                    return true;
                }
                Level level = this.level;
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (player instanceof ServerPlayer) break block7;
            }
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        return this.performInteraction(new PlayerInteractionExecutor(serverPlayer, interactionHand, this), serverLevel, itemInHand).success();
    }

    public InteractionResult interactWithPen(ServerLevel serverLevel, BlockSource source, ItemStack itemInHand) {
        if (this.getOwner().isPresent()) {
            AnimalPen.sendDebug("Protection is enabled");
            return InteractionResult.FAILED;
        }
        Mob animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal is not set");
            return InteractionResult.FAILED;
        }
        return this.performInteraction(new DispenserInteractionExecutor(serverLevel, (Container)source.blockEntity(), this), serverLevel, itemInHand);
    }

    public void attackThePen(Player player, Level level) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.getUUID())) {
            AnimalPen.sendDebug("Protection is enabled");
            return;
        }
        ItemStack weapon = player.getItemInHand(InteractionHand.MAIN_HAND);
        Mob animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal Pen is empty");
            return;
        }
        long amount = this.getAnimalCount();
        if (amount <= this.protectedAmount) {
            AnimalPen.sendDebug("Protected amount reached");
            return;
        }
        if (!this.updateAnimalCount(-1L)) {
            AnimalPen.sendDebug("Failed to update animal count");
            return;
        }
        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)((ServerLevel)level), (Entity)animal, (DamageSource)level.damageSources().playerAttack(player), (ItemStack)weapon);
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.awardStat(Stats.ITEM_USED.get((Object)weapon.getItem()));
        }
        weapon.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        this.deathTicker.add(0);
        if (this.getAnimalCount() <= 0L) {
            ItemStack item = this.getItemStack();
            item.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
            item.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
            item.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get());
            Block.popResource((Level)level, (BlockPos)this.getBlockPos().above(), (ItemStack)item);
            this.inventory.setItem(0, ItemStack.EMPTY);
            AnimalPen.sendDebug("Dropping empty cage");
        }
        this.triggerUpdate();
        Vec3 position = new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(animal.getLootTable());
        LootParams.Builder paramsBuilder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)position).withParameter(LootContextParams.THIS_ENTITY, (Object)animal).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().playerAttack(player)).withLuck(player.getLuck());
        lootTable.getRandomItems(paramsBuilder.create(LootContextParamSets.ENTITY), level.getRandom().nextLong()).forEach(itemStack -> ItemTransferUtil.insertBellowOrDrop(level, itemStack, this.getBlockPos(), this.getBlockPos().above()));
        animal.clearFire();
        int reward = animal.getExperienceReward((ServerLevel)level, (Entity)player);
        ExperienceOrb.award((ServerLevel)((ServerLevel)this.level), (Vec3)position.add(0.5, 1.0, 0.5), (int)reward);
        if (AnimalPen.config().isTriggerAdvancements()) {
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger((ServerPlayer)player, (Entity)animal, level.damageSources().playerAttack(player));
        }
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.awardStat(Stats.MOB_KILLS);
            player.awardStat(Stats.ENTITY_KILLED.get((Object)animal.getType()));
        }
        AnimalPen.sendDebug("Animal Kill process finished");
    }

    private InteractionResult performInteraction(AnimalInteractionExecutor executor, ServerLevel serverLevel, ItemStack itemInHand) {
        int consumedAmount;
        ItemStack consumedItem;
        Mob animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal is not set");
            return InteractionResult.FAILED;
        }
        ItemStack mobItemStack = this.getItemStack();
        Optional<AnimalInteraction> interactionOptional = AnimalPenInteractionRegistry.matchInteraction(animal, (DataComponentHolder)mobItemStack, itemInHand);
        if (interactionOptional.isEmpty()) {
            AnimalPen.sendDebug("Interaction with " + String.valueOf(this.getBlockPos()) + " cannot be success with " + String.valueOf(itemInHand));
            return InteractionResult.FAILED;
        }
        if (!mobItemStack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get()) || !mobItemStack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())) {
            AnimalPen.sendDebug("Interaction with " + String.valueOf(this.getBlockPos()) + " cannot be success as data is missing.");
            return InteractionResult.FAILED;
        }
        StoredMob storedMob = (StoredMob)mobItemStack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
        StoredMobData storedMobData = (StoredMobData)mobItemStack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
        AnimalInteraction interaction = interactionOptional.get();
        long animalCount = interaction.normalizeMobCount(storedMobData.animalCount());
        boolean dataUpdate = false;
        ConsumerEntry itemConsumer = interaction.consumer();
        if (itemConsumer == null) {
            consumedItem = ItemStack.EMPTY;
            consumedAmount = 1;
        } else {
            consumedItem = itemConsumer.getConsumedItem(itemInHand);
            consumedAmount = (int)itemConsumer.calculateConsumption(executor, consumedItem, animalCount, interaction.even());
        }
        if (consumedAmount == 0) {
            AnimalPen.sendDebug("Need at least 1 items in stack");
            return InteractionResult.FAILED;
        }
        dataUpdate |= interaction.applyCooldown(mobItemStack, animalCount);
        List<ItemStack> lootItems = interaction.lootEntry() == null ? Collections.emptyList() : interaction.lootEntry().processLootTable(serverLevel, animal, this.getBlockPos(), animalCount, consumedAmount);
        executor.triggerItemUse(animal, itemInHand, consumedAmount);
        if (itemConsumer == null) {
            lootItems.forEach(itemStack -> ItemTransferUtil.insertBellowOrDrop((Level)serverLevel, itemStack, this.getBlockPos(), this.dropPosition()));
        } else {
            itemInHand = itemConsumer.consumeItems(executor, lootItems, itemInHand, consumedAmount);
        }
        if (interaction.sound() != null) {
            this.level.registryAccess().registry(Registries.SOUND_EVENT).flatMap(registry -> registry.getOptional(interaction.sound())).ifPresent(soundEvent -> this.level.playSound(null, this.getBlockPos(), soundEvent, SoundSource.AMBIENT, 1.0f, Mth.randomBetween((RandomSource)this.level.getRandom(), (float)0.8f, (float)1.2f)));
        }
        if (dataUpdate |= executor.triggerFunctions(interaction, consumedItem, consumedAmount, animal, mobItemStack, this.getBlockPos())) {
            AnimalPen.sendDebug("Animal Interaction finished");
            if (this.getAnimalCount() <= 0L) {
                mobItemStack.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
                mobItemStack.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
                mobItemStack.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get());
                Block.popResource((Level)serverLevel, (BlockPos)this.getBlockPos().above(), (ItemStack)mobItemStack);
                this.inventory.setItem(0, ItemStack.EMPTY);
                AnimalPen.sendDebug("Dropping empty cage");
            } else {
                AnimalPen.sendDebug("Updating cage tag");
                this.inventory.setChanged();
            }
            this.triggerUpdate();
            return new InteractionResult(true, itemInHand);
        }
        return InteractionResult.FAILED;
    }

    private boolean requiresClientUpdate(Mob mob, String key) {
        return AnimalPenInteractionRegistry.getInteractions(mob).stream().filter(interaction -> key.equals(interaction.id())).anyMatch(interaction -> !interaction.textLines().isEmpty());
    }

    private void triggerEndFunctions(ServerLevel level, Mob mob, ItemStack componentHolder, String key) {
        AnimalPenInteractionRegistry.getInteractions(mob).stream().filter(interaction -> key.equals(interaction.id())).filter(interaction -> !interaction.finishFunctions().isEmpty()).findFirst().map(AnimalInteraction::finishFunctions).orElse(List.of()).forEach(function -> function.id().processFunction(level, mob, componentHolder, this.getBlockPos(), function.key(), function.value()));
    }

    private boolean triggerStartFunctions(ServerLevel level, Mob mob, ItemStack componentHolder, Map<String, Integer> newCooldowns) {
        List<AnimalInteraction> interactions = AnimalPenInteractionRegistry.getInteractions(mob).stream().filter(interaction -> !newCooldowns.containsKey(interaction.id())).filter(interaction -> interaction.ingredient().isEmpty()).filter(interaction -> interaction.matchAllConditions((DataComponentHolder)componentHolder)).toList();
        boolean anyChanges = false;
        for (AnimalInteraction interaction2 : interactions) {
            if (interaction2.cooldown() != null) {
                long animalCount = AnimalPenItemHelper.getMobCount((DataComponentHolder)componentHolder);
                int cooldownTime = (int)interaction2.cooldown().calculateCooldown(animalCount);
                newCooldowns.put(interaction2.id(), cooldownTime);
                anyChanges = true;
            }
            if (interaction2.sound() != null) {
                this.level.registryAccess().registry(Registries.SOUND_EVENT).flatMap(registry -> registry.getOptional(interaction2.sound())).ifPresent(soundEvent -> level.playSound(null, this.getBlockPos(), soundEvent, SoundSource.AMBIENT, 1.0f, Mth.randomBetween((RandomSource)level.getRandom(), (float)0.8f, (float)1.2f)));
            }
            for (FunctionKey function : interaction2.runFunctions()) {
                anyChanges |= function.id().processFunction(level, mob, componentHolder, this.getBlockPos(), function.key(), function.value());
            }
        }
        return anyChanges;
    }

    public List<CompoundTag> getEntityVariants() {
        return this.getStoredAnimal().map(animal -> AnimalPenVariantHelper.getAnimalVariants(this.getItemStack()).orElseGet(Collections::emptyList)).orElseGet(Collections::emptyList);
    }

    public void updateAnimalVariant(CompoundTag animalVariant) {
        if (animalVariant == null || animalVariant.isEmpty()) {
            return;
        }
        this.getStoredAnimal().ifPresent(animal -> {
            AnimalPen.sendDebug("Animal Variant changed");
            animal.load(animalVariant);
            ItemStack itemStack = this.getItemStack();
            StoredMob storedMob = (StoredMob)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
            itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get(), (Object)StoredMob.of(storedMob.entityType(), animalVariant));
            this.triggerUpdate();
            if (this.level != null && !this.level.isClientSide()) {
                NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
            }
        });
    }

    public void removeAnimalVariant(int index) {
        ItemStack itemStack = this.getItemStack();
        if (itemStack.isEmpty()) {
            return;
        }
        if (!itemStack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get())) {
            return;
        }
        StoredMobVariants storedMobVariants = (StoredMobVariants)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get());
        List<CompoundTag> variants = storedMobVariants.variants();
        if (index >= variants.size()) {
            return;
        }
        variants.remove(index);
        itemStack.update((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get(), (Object)StoredMobVariants.of(new ArrayList<CompoundTag>()), data -> StoredMobVariants.of(variants));
        this.triggerUpdate();
        if (this.level != null && !this.level.isClientSide()) {
            NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
            AnimalPen.sendDebug("Animal variant removed");
        }
    }

    public boolean validateItemStack() {
        return this.validateItemStack(this.getItemStack());
    }

    public abstract boolean validateItemStack(ItemStack var1);

    public abstract boolean canGrowEntity();

    public abstract BlockPos dropPosition();

    public List<Integer> getDeathTicker() {
        return this.deathTicker;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public long getAnimalDisplaySize() {
        return this.displaySize < 1L ? this.getAnimalCount() : Math.min(this.displaySize, this.getAnimalCount());
    }

    public void setAnimalDisplaySize(long size) {
        this.displaySize = size;
        this.triggerUpdate();
    }

    public long getProtectedAmount() {
        return this.protectedAmount;
    }

    public void setProtectedAmount(long amount) {
        this.protectedAmount = amount;
        this.triggerUpdate();
    }

    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.ownerUUID);
    }

    public void setOwner(@Nullable UUID owner) {
        this.ownerUUID = owner;
        this.triggerUpdate();
    }

    public long getAnimalCount() {
        if (!this.validateItemStack()) {
            return 0L;
        }
        return AnimalPenItemHelper.getMobCount((DataComponentHolder)this.getItemStack());
    }

    public boolean updateAnimalCount(long change) {
        if (!this.validateItemStack()) {
            return false;
        }
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())) {
            return false;
        }
        StoredMobData data = (StoredMobData)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
        long animalCount = data.animalCount();
        if (change < 0L && animalCount + change < 0L) {
            return false;
        }
        long maxCount = AnimalPen.config().getMaximalAnimalCount();
        if (maxCount > 0L && animalCount + change > maxCount) {
            return false;
        }
        itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(animalCount + change, data.properties(), data.cooldowns()));
        return true;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    private ItemStack getItemStack() {
        return this.inventory.getItem(0);
    }

    public Optional<Mob> getStoredAnimal() {
        if (this.level == null) {
            return Optional.ofNullable(this.storedAnimal);
        }
        ItemStack itemStack = this.getItemStack();
        if (this.storedAnimal == null && !itemStack.isEmpty()) {
            StoredMob customData = (StoredMob)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
            if (customData == null) {
                return Optional.ofNullable(this.storedAnimal);
            }
            StoredMob storedMob = (StoredMob)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
            Entity entity = storedMob.entityType().create(this.level);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.load(storedMob.tag());
                this.storedAnimal = mob;
            }
        } else if (this.storedAnimal != null && itemStack.isEmpty()) {
            this.storedAnimal = null;
        }
        return Optional.ofNullable(this.storedAnimal);
    }

    public List<Pair<ItemStack[], Component>> getCooldownLines(boolean shortText) {
        Map<Object, Object> properties;
        Map<Object, Object> cooldowns;
        long animalCount;
        ArrayList<Pair<ItemStack[], Component>> textLines = new ArrayList<Pair<ItemStack[], Component>>();
        if (this.getItemStack().has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())) {
            StoredMobData storedMobData = (StoredMobData)this.getItemStack().get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
            animalCount = storedMobData.animalCount();
            cooldowns = storedMobData.cooldowns();
            properties = storedMobData.properties();
        } else {
            animalCount = 0L;
            cooldowns = Collections.emptyMap();
            properties = Collections.emptyMap();
        }
        this.getStoredAnimal().ifPresent(animal -> AnimalPenInteractionRegistry.getInteractions(animal).stream().filter(animalInteraction -> !animalInteraction.textLines().isEmpty()).filter(animalInteraction -> AnimalPen.config().isShowAllInteractions() || !shortText || animalInteraction.cooldown() != null && animalInteraction.cooldown().calculateCooldown(animalCount) != 0L).forEach(animalInteraction -> {
            boolean matchConditions = animalInteraction.matchAllConditions((DataComponentHolder)this.getItemStack());
            animalInteraction.textLines().forEach(line -> {
                Pair<ItemStack[], Component> textIconPair;
                boolean containsInCooldown = cooldowns.containsKey(animalInteraction.id());
                boolean shouldExecute = switch (line.visibility()) {
                    default -> throw new MatchException(null, null);
                    case TextEntryVisibility.READY -> {
                        if (matchConditions && !containsInCooldown) {
                            yield true;
                        }
                        yield false;
                    }
                    case TextEntryVisibility.COOLDOWN -> {
                        if (matchConditions && containsInCooldown) {
                            yield true;
                        }
                        yield false;
                    }
                    case TextEntryVisibility.NOT_MATCH -> {
                        if (!matchConditions) {
                            yield true;
                        }
                        yield false;
                    }
                    case TextEntryVisibility.ON_MATCH -> matchConditions;
                };
                Pair<ItemStack[], Component> pair = textIconPair = shouldExecute ? line.animalPenGetLine(animalInteraction.ingredient(), properties, this.tickCounter, shortText, cooldowns.getOrDefault(animalInteraction.id(), 0).intValue()) : null;
                if (textIconPair != null) {
                    textLines.add(textIconPair);
                }
            });
        }));
        return textLines;
    }

    public int getRedStoneSignal() {
        return this.getStoredAnimal().map(animal -> {
            Collection<AnimalInteraction> interactions = AnimalPenInteractionRegistry.getInteractions(animal);
            Map<String, Integer> cooldowns = AnimalPenItemHelper.getCooldowns((DataComponentHolder)this.getItemStack());
            int returnValue = 1;
            for (AnimalInteraction interaction : interactions) {
                if (interaction.redstoneSignal() <= 0 || interaction.redstoneSignal() >= 4 || !interaction.matchAllConditions((DataComponentHolder)this.getItemStack()) || cooldowns.containsKey(interaction.id())) continue;
                returnValue |= 1 << interaction.redstoneSignal();
            }
            return returnValue;
        }).orElse(0);
    }

    public record InteractionResult(boolean success, ItemStack result) {
        static InteractionResult FAILED = new InteractionResult(false, ItemStack.EMPTY);
    }
}

