/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import lv.id.bonne.animalpen.registries.AnimalPenBlockRegistry;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public interface WeatheringCopperAviary
extends WeatheringCopper {
    public static final Supplier<BiMap<Block, Block>> OXIDATION_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)AnimalPenBlockRegistry.COPPER_AVIARIES.get(WeatheringCopper.WeatherState.UNAFFECTED).get()), (Object)((Block)AnimalPenBlockRegistry.COPPER_AVIARIES.get(WeatheringCopper.WeatherState.EXPOSED).get())).put((Object)((Block)AnimalPenBlockRegistry.COPPER_AVIARIES.get(WeatheringCopper.WeatherState.EXPOSED).get()), (Object)((Block)AnimalPenBlockRegistry.COPPER_AVIARIES.get(WeatheringCopper.WeatherState.WEATHERED).get())).put((Object)((Block)AnimalPenBlockRegistry.COPPER_AVIARIES.get(WeatheringCopper.WeatherState.WEATHERED).get()), (Object)((Block)AnimalPenBlockRegistry.COPPER_AVIARIES.get(WeatheringCopper.WeatherState.OXIDIZED).get())).build());
    public static final Supplier<BiMap<Block, Block>> OXIDATION_LEVEL_DECREASES = Suppliers.memoize(() -> OXIDATION_LEVEL_INCREASES.get().inverse());
    public static final Supplier<BiMap<Block, Block>> UNWAXED_TO_WAXED_BLOCKS = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (WeatheringCopper.WeatherState value : WeatheringCopper.WeatherState.values()) {
            builder.put((Object)((Block)AnimalPenBlockRegistry.COPPER_AVIARIES.get(value).get()), (Object)((Block)AnimalPenBlockRegistry.WAXED_COPPER_AVIARIES.get(value).get()));
        }
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> WAXED_TO_UNWAXED_BLOCKS = Suppliers.memoize(() -> UNWAXED_TO_WAXED_BLOCKS.get().inverse());

    public static Optional<Block> getPrevious(Block block) {
        return Optional.ofNullable((Block)OXIDATION_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Optional<BlockState> getPrevious(BlockState blockState) {
        return WeatheringCopperAviary.getPrevious(blockState.getBlock()).map(block -> block.withPropertiesOf(blockState));
    }

    @NotNull
    public static Optional<Block> getNext(Block block) {
        return Optional.ofNullable((Block)OXIDATION_LEVEL_INCREASES.get().get((Object)block));
    }

    @NotNull
    default public Optional<BlockState> getNext(@NotNull BlockState blockState) {
        return WeatheringCopperAviary.getNext(blockState.getBlock()).map(block -> block.withPropertiesOf(blockState));
    }
}

