/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin;

import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CropBlock.class})
public class CropGrowsMixin {
    @Inject(method={"randomTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelCropGrowth(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        boolean hasOxygen = GlobalOxygenManager.getInstance().getOrCreateDimensionManager(level).hasOxygenAt(pos);
        Planet planet = PlanetUtil.getPlanet(level.dimension().location());
        if (!(planet == null || planet.oxygen() || state.is(TagRegistry.ALIEN_CROPS) || hasOxygen)) {
            ci.cancel();
        }
    }

    @Inject(method={"mayPlaceOn(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelCropPlacement(BlockState state, BlockGetter level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean hasOxygen = GlobalOxygenManager.getInstance().getOrCreateDimensionManager(serverLevel).hasOxygenAt(pos);
            Planet planet = PlanetUtil.getPlanet(serverLevel.dimension().location());
            if (!(planet == null || planet.oxygen() || state.is(TagRegistry.ALIEN_CROPS) || hasOxygen)) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

