/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils.capabilities.fluid;

import com.fej1fun.potentials.fluid.BaseFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public abstract class FluidStorage
extends BaseFluidStorage {
    public FluidStorage(int tanks, long capacity, long maxFill, long maxDrain) {
        super(tanks, capacity, maxFill, maxDrain);
    }

    public FluidStorage(int tanks, long capacity) {
        super(tanks, capacity);
    }

    public long fill(FluidStack stack, boolean simulate) {
        long filled = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack fluidStack;
            if (!this.isFluidValid(i, stack) || (fluidStack = (FluidStack)this.fluidStacks.get(i)).getFluid() != stack.getFluid() && !fluidStack.isEmpty() || fluidStack.getAmount() >= this.capacity) continue;
            long inTank = this.getFluidValueInTank(i);
            filled = Math.clamp(this.capacity - inTank, 0L, Math.min(this.maxFill, stack.getAmount()));
            if (simulate) break;
            this.fluidStacks.set(i, (Object)stack.copyWithAmount(inTank + filled));
            this.onChange(i);
            break;
        }
        return filled;
    }

    public FluidStack drain(FluidStack stack, boolean simulate) {
        long drained = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack fluid;
            if (!this.isFluidValid(i, stack) || (fluid = this.getFluidInTank(i)).isEmpty() || fluid.getFluid() != stack.getFluid()) continue;
            drained = Math.min(this.getFluidValueInTank(i), Math.min(this.maxDrain, stack.getAmount()));
            if (simulate) break;
            this.setFluidInTank(i, FluidStack.create((FluidStack)fluid, (long)(this.getFluidValueInTank(i) - drained)));
            this.onChange(i);
            break;
        }
        return FluidStack.create((FluidStack)stack, (long)drained);
    }

    public long fillWithoutLimits(FluidStack stack, boolean simulate) {
        long filled = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (!this.isFluidValid(i, stack) || ((FluidStack)this.fluidStacks.get(i)).getFluid() != stack.getFluid() && !((FluidStack)this.fluidStacks.get(i)).isEmpty() || ((FluidStack)this.fluidStacks.get(i)).getAmount() >= this.capacity) continue;
            filled = Math.clamp(this.capacity - this.getFluidValueInTank(i), 0L, stack.getAmount());
            if (simulate) break;
            this.fluidStacks.set(i, (Object)stack.copyWithAmount(this.getFluidValueInTank(i) + filled));
            this.onChange(i);
            break;
        }
        return filled;
    }

    public FluidStack drainWithoutLimits(FluidStack stack, boolean simulate) {
        long drained = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (!this.isFluidValid(i, stack) || this.getFluidInTank(i).isEmpty() || this.getFluidInTank(i).getFluid() != stack.getFluid()) continue;
            drained = Math.min(this.getFluidValueInTank(i), stack.getAmount());
            if (simulate) break;
            ((FluidStack)this.fluidStacks.get(i)).shrink(drained);
            this.onChange(i);
            break;
        }
        return FluidStack.create((FluidStack)stack, (long)drained);
    }

    public void save(CompoundTag compoundTag, HolderLookup.Provider provider, String name) {
        for (int i = 0; i < this.getTanks(); ++i) {
            if (this.getFluidInTank(i).isEmpty()) continue;
            compoundTag.put(name + "-fluid-" + i, FluidStackHooks.write((HolderLookup.Provider)provider, (FluidStack)this.getFluidInTank(i), (Tag)new CompoundTag()));
        }
    }

    public void load(CompoundTag compoundTag, HolderLookup.Provider provider, String name) {
        for (int i = 0; i < this.getTanks(); ++i) {
            if (!compoundTag.contains(name + "-fluid-" + i)) continue;
            this.setFluidInTank(i, FluidStackHooks.read((HolderLookup.Provider)provider, (Tag)compoundTag.get(name + "-fluid-" + i)).orElse(FluidStack.empty()));
        }
    }

    public boolean isEmpty() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FluidStack stack = (FluidStack)iterator.next();
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected abstract void onChange(int var1);
}

