/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class PlanetSelectionMenu
extends AbstractContainerMenu {
    private final Player player;
    private final boolean forceCanGoTo;
    private final String galaxyId;
    public boolean freeze_gui = false;

    public PlanetSelectionMenu(int syncId, Inventory playerInventory, boolean forceCanGoTo, String galaxyId) {
        super((MenuType)MenuTypesRegistry.PLANET_SELECTION_MENU.get(), syncId);
        this.player = playerInventory.player;
        this.forceCanGoTo = forceCanGoTo;
        this.galaxyId = galaxyId;
    }

    public static PlanetSelectionMenu create(int syncId, Inventory inventory, FriendlyByteBuf data) {
        boolean forceCanGoTo = data.readBoolean();
        String galaxyId = data.readUtf();
        return new PlanetSelectionMenu(syncId, inventory, forceCanGoTo, galaxyId);
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return !player.isDeadOrDying();
    }

    public Player getPlayer() {
        return this.player;
    }

    public void switchFreezeGui() {
        this.freeze_gui = !this.freeze_gui;
    }

    public boolean getForceCanGoTo() {
        return this.forceCanGoTo;
    }

    public String getGalaxyId() {
        return this.galaxyId;
    }
}

