/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.events.custom.PlanetSelectionClientEvents;
import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.info.PlanetInfo;
import com.st0x0ef.stellaris.client.screens.record.PlanetRecord;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlanetPack
extends SimpleJsonResourceReloadListener {
    public PlanetPack() {
        super(Stellaris.GSON, "renderer/planet_screen/planet");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        object.forEach((key, value) -> {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)value, (String)"planets");
            PlanetRecord planet = (PlanetRecord)PlanetRecord.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
            PlanetInfo screenPlanet = new PlanetInfo(planet.texture(), planet.name(), (double)planet.distance(), planet.period(), (float)planet.width(), (float)planet.height(), PlanetSelectionScreen.findByNameStar(planet.parent()), planet.dimensionId(), (Component)Component.translatable((String)planet.translatable()), planet.id(), (boolean)planet.spaceStation().orElse(false), (boolean)planet.canLaunchOn().orElse(true));
            planet.spaceStation().ifPresent(screenPlanet::setSpaceStation);
            planet.canLaunchOn().ifPresent(screenPlanet::setCanLaunchOn);
            for (int i = 0; i < PlanetSelectionScreen.PLANETS.size(); ++i) {
                if (!PlanetSelectionScreen.PLANETS.get(i).getId().equals(planet.id())) continue;
                PlanetSelectionScreen.PLANETS.set(i, screenPlanet);
                Stellaris.LOG.info("Replaced existing planet in PlanetSelectionScreen : {}", (Object)planet.name());
                return;
            }
            PlanetSelectionScreen.PLANETS.add(screenPlanet);
            Stellaris.LOG.info("Added a new planet to PlanetSelectionScreen : {}", (Object)planet.name());
        });
        ((PlanetSelectionClientEvents.PostPlanetPackRegistryEvent)PlanetSelectionClientEvents.POST_PLANET_PACK_REGISTRY.invoker()).planetRegistered(PlanetSelectionScreen.PLANETS);
    }
}

