/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.recipes.input;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public record ItemInput(Optional<ResourceLocation> item, Optional<TagKey<Item>> tag, int count) {
    public static final Codec<ItemInput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("item").forGetter(ItemInput::item), (App)TagKey.codec((ResourceKey)BuiltInRegistries.ITEM.key()).optionalFieldOf("tag").forGetter(ItemInput::tag), (App)Codec.INT.fieldOf("count").forGetter(ItemInput::count)).apply((Applicative)instance, ItemInput::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemInput> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemInput>(){

        @NotNull
        public ItemInput decode(RegistryFriendlyByteBuf buf) {
            return new ItemInput(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ItemInput packet) {
            buf.writeOptional(packet.item, (StreamEncoder)ResourceLocation.STREAM_CODEC);
            buf.writeOptional(packet.tag, TAG_KEY_STREAM_CODEC);
            buf.writeInt(packet.count);
        }
    };
    private static final StreamCodec<FriendlyByteBuf, TagKey<Item>> TAG_KEY_STREAM_CODEC = StreamCodec.of((buf, tagKey) -> buf.writeResourceLocation(tagKey.location()), buf -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)buf.readResourceLocation()));

    public ItemInput(RegistryFriendlyByteBuf buffer) {
        this(buffer.readOptional((StreamDecoder)ResourceLocation.STREAM_CODEC), buffer.readOptional(TAG_KEY_STREAM_CODEC), buffer.readInt());
    }

    public List<Item> getItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        if (this.item.isPresent()) {
            items.add((Item)BuiltInRegistries.ITEM.get(this.item.get()));
        } else if (this.tag.isPresent()) {
            BuiltInRegistries.ITEM.getTagOrEmpty(this.tag.get()).forEach(holder -> items.add((Item)holder.value()));
        } else {
            throw new IllegalStateException("ItemInput must have either an item or a tag defined.");
        }
        return items;
    }

    public String getDisplayName() {
        if (this.item.isPresent()) {
            return ((Item)BuiltInRegistries.ITEM.get(this.item.get())).getDescription().getString();
        }
        if (this.tag.isPresent()) {
            return "#" + this.tag.get().location().getNamespace() + ":" + this.tag.get().location().getPath();
        }
        return "Unknown ItemInput";
    }
}

