/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.machines;

import com.fej1fun.potentials.energy.BaseEnergyStorage;
import com.fej1fun.potentials.energy.ItemEnergyStorage;
import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import com.fej1fun.potentials.providers.EnergyProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.PowerBankEntity;
import com.st0x0ef.stellaris.common.blocks.machines.BaseMachineBlock;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerBankBlock
extends BaseMachineBlock {
    public final short tier;
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)9);

    public PowerBankBlock(BlockBehaviour.Properties properties, short tier) {
        super(properties);
        this.tier = tier;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockEntityType<?> getBlockEntityType() {
        return BlockEntityRegistry.POWER_BANK.get();
    }

    @Override
    public boolean hasTicker(Level level) {
        return !level.isClientSide;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PowerBankEntity(pos, state, this.tier);
    }

    @NotNull
    protected MapCodec<? extends PowerBankBlock> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)PowerBankBlock.propertiesCodec(), (App)Codec.SHORT.fieldOf("tier").forGetter(bank -> bank.tier)).apply((Applicative)instance, PowerBankBlock::new));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof EnergyProvider.ITEM) {
            EnergyProvider.ITEM provider = (EnergyProvider.ITEM)item;
            UniversalEnergyStorage energyStorage = provider.getEnergy(stack);
            BlockEntity be = level.getBlockEntity(pos);
            if (energyStorage != null && be instanceof BaseEnergyContainerBlockEntity) {
                BaseEnergyContainerBlockEntity energyBlock = (BaseEnergyContainerBlockEntity)be;
                energyBlock.getEnergy(null).setEnergyStored(energyStorage.getEnergy());
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STAGE});
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        player.awardStat(Stats.BLOCK_MINED.get((Object)this));
        player.causeFoodExhaustion(0.005f);
        if (level instanceof ServerLevel) {
            if (blockEntity instanceof BaseEnergyContainerBlockEntity) {
                BaseEnergyContainerBlockEntity energyBlock = (BaseEnergyContainerBlockEntity)blockEntity;
                BaseEnergyStorage energy = energyBlock.getEnergy(null);
                ItemStack stack = new ItemStack((ItemLike)this);
                EnergyProvider.ITEM provider = (EnergyProvider.ITEM)stack.getItem();
                UniversalEnergyStorage universalEnergyStorage = provider.getEnergy(stack);
                if (universalEnergyStorage instanceof ItemEnergyStorage) {
                    ItemEnergyStorage storage = (ItemEnergyStorage)universalEnergyStorage;
                    storage.setEnergyStored(energy.getEnergy());
                }
                PowerBankBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
            state.spawnAfterBreak((ServerLevel)level, pos, tool, false);
        }
    }
}

