/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.blocks.machines.BaseTickingEntityBlock;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class RadioactiveBlock
extends BaseTickingEntityBlock {
    public static final MapCodec<RadioactiveBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RadioactiveBlock.propertiesCodec(), (App)Codec.INT.fieldOf("level").forGetter(RadioactiveBlock::getRadioactivityLevel)).apply((Applicative)instance, RadioactiveBlock::new));
    private final int radioactivityLevel;

    public RadioactiveBlock(BlockBehaviour.Properties properties, int level) {
        super(properties);
        this.radioactivityLevel = level;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public BlockEntityType<?> getBlockEntityType() {
        return (BlockEntityType)BlockEntityRegistry.RADIOACTIVE_BLOCK.get();
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public boolean hasTicker(Level level) {
        return !level.isClientSide;
    }

    public int getRadioactivityLevel() {
        return this.radioactivityLevel;
    }
}

