/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class FluidGaugeWidget
extends AbstractWidget {
    private static final TextureAtlasSprite WATER_STILL_SPRITE = FluidStackHooks.getStillTexture((Fluid)Fluids.WATER);
    private final int tank;
    protected final Supplier<? extends UniversalFluidStorage> fluidStorage;
    private Fluid currFluid = null;
    private int fluidColor = 1;
    protected TextureAtlasSprite sprite;
    @Nullable
    protected ResourceLocation overlaySprite;
    protected final GaugeWidget.Direction4 DIRECTION;
    protected int imageWidth;
    protected int imageHeight;

    public FluidGaugeWidget(int x, int y, int width, int height, Component message, Supplier<? extends UniversalFluidStorage> fluidStorage, int tank, GaugeWidget.Direction4 direction) {
        super(x, y, width, height, message);
        this.fluidStorage = fluidStorage;
        this.tank = tank;
        this.overlaySprite = null;
        this.DIRECTION = direction;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        UniversalFluidStorage fluids = this.fluidStorage.get();
        Fluid fluid = fluids.getFluidInTank(this.tank).getFluid();
        if (fluid != this.currFluid || this.currFluid == null) {
            this.currFluid = fluid;
            this.updateLiquid(this.currFluid);
        }
        long amount = fluids.getFluidInTank(this.tank).getAmount();
        long capacity = fluids.getTankCapacity(this.tank);
        RenderSystem.setShaderColor((float)((float)(this.fluidColor >> 16 & 0xFF) / 255.0f), (float)((float)(this.fluidColor >> 8 & 0xFF) / 255.0f), (float)((float)(this.fluidColor & 0xFF) / 255.0f), (float)((float)(this.fluidColor >> 24 & 0xFF) / 255.0f));
        switch (this.DIRECTION) {
            case DOWN_UP: {
                int i = Mth.ceil((double)(this.getProgress(amount, capacity) * (double)(this.getHeight() - 1)));
                for (int j = 0; j < this.width / this.imageWidth; ++j) {
                    guiGraphics.blitSprite(this.sprite, this.imageWidth, this.getHeight(), 0, this.getHeight() - i, this.getX() + this.imageWidth * j, this.getY() + this.getHeight() - i, 0, this.imageWidth, i);
                }
                int x = this.width % this.imageWidth;
                if (x <= 0) break;
                guiGraphics.blitSprite(this.sprite, x, this.getHeight(), 0, this.getHeight() - i, this.getX() + this.width - x, this.getY() + this.getHeight() - i, 0, x, i);
                break;
            }
            case UP_DOWN: {
                int i = Mth.ceil((double)(this.getProgress(amount, capacity) * (double)(this.getHeight() - 1)));
                for (int j = 0; j < this.width / this.imageWidth; ++j) {
                    guiGraphics.blitSprite(this.sprite, this.imageWidth, this.getHeight(), 0, 0, this.getX() + this.imageWidth * j, this.getY(), 0, this.imageWidth, i);
                }
                int x = this.width % this.imageWidth;
                if (x <= 0) break;
                guiGraphics.blitSprite(this.sprite, x, this.getHeight(), 0, 0, this.getX() + this.width - x, this.getY(), 0, x, i);
                break;
            }
            case LEFT_RIGHT: {
                int i = Mth.ceil((double)(this.getProgress(amount, capacity) * (double)(this.getWidth() - 1)));
                for (int j = 0; j < this.height / this.imageHeight; ++j) {
                    guiGraphics.blitSprite(this.sprite, this.getWidth(), this.imageHeight, 0, 0, this.getX(), this.getY() + this.imageHeight * j, 0, i, this.imageHeight);
                }
                int y = this.height % this.imageHeight;
                if (y <= 0) break;
                guiGraphics.blitSprite(this.sprite, this.getWidth(), y, 0, 0, this.getX(), this.getY() + this.height - y, 0, i, y);
                break;
            }
            case RIGHT_LEFT: {
                int i = Mth.ceil((double)(this.getProgress(amount, capacity) * (double)(this.getWidth() - 1)));
                for (int j = 0; j < this.height / this.imageHeight; ++j) {
                    guiGraphics.blitSprite(this.sprite, this.getWidth(), this.imageHeight, this.getWidth() - i, 0, this.getX() + this.getWidth() - i, this.getY() + this.imageHeight * j, 0, i, this.imageHeight);
                }
                int y = this.height % this.imageHeight;
                if (y <= 0) break;
                guiGraphics.blitSprite(this.sprite, this.getWidth(), y, this.getWidth() - i, 0, this.getX() + this.getWidth() - i, this.getY() + this.height - y, 0, i, y);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.overlaySprite != null) {
            guiGraphics.blitSprite(this.overlaySprite, this.getX(), this.getY(), this.width, this.height);
        }
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY, Font font) {
        this.renderTooltips(graphics, mouseX, mouseY, font, list -> {});
    }

    public void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY, Font font, Consumer<List<Component>> components) {
        UniversalFluidStorage fluids = this.fluidStorage.get();
        long amount = fluids.getFluidInTank(this.tank).getAmount();
        long capacity = fluids.getTankCapacity(this.tank);
        String GaugeComponent = this.getMessage().getString() + " : " + amount + " / " + capacity;
        Component capacityComponent = amount >= capacity ? Utils.getMessageComponent(GaugeComponent, "Lime") : (amount <= 0L ? Utils.getMessageComponent(GaugeComponent, "Red") : Utils.getMessageComponent(GaugeComponent, "Orange"));
        ArrayList<Component> components1 = new ArrayList<Component>();
        components.accept(components1);
        components1.addFirst(capacityComponent);
        if (mouseX >= this.getX() && mouseX <= this.getX() + this.width && mouseY >= this.getY() && mouseY <= this.getY() + this.height) {
            graphics.renderComponentTooltip(font, components1, mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    protected double getProgress(Long amount, Long capacity) {
        return Mth.clamp((double)((double)amount.longValue() / (double)capacity.longValue()), (double)0.0, (double)1.0);
    }

    public FluidGaugeWidget setOverlaySprite(@Nullable ResourceLocation overlaySprite) {
        this.overlaySprite = overlaySprite;
        return this;
    }

    private void updateLiquid(Fluid fluid) {
        TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((Fluid)fluid);
        if (sprite == null || fluid == Fluids.WATER) {
            sprite = WATER_STILL_SPRITE;
        }
        this.fluidColor = FluidStackHooks.getColor((Fluid)fluid);
        assert (sprite != null);
        SpriteContents contents = sprite.contents();
        this.imageHeight = contents.height();
        this.imageWidth = contents.width();
        this.sprite = sprite;
    }
}

