/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.CustomCheckBox;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.common.blocks.entities.machines.AntennaBlockEntity;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadUtils;
import com.st0x0ef.stellaris.common.menus.AntennaMenu;
import com.st0x0ef.stellaris.common.network.packets.LaunchPadsOperations;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AntennaScreen
extends AbstractContainerScreen<AntennaMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/antenna.png");
    private final AntennaBlockEntity blockEntity = ((AntennaMenu)this.getMenu()).getBlockEntity();
    private EditBox nameBox;
    private EditBox whitelistBox;
    private CustomCheckBox publicCheckbox;
    private TexturedButton saveButton;
    public LaunchPad pad;

    public AntennaScreen(AntennaMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 180;
        this.imageHeight = 188;
        this.inventoryLabelY = this.imageHeight - 94;
        if (menu.launchPadId != -1) {
            this.pad = LaunchPadUtils.getPadById(menu.launchPadId);
        }
    }

    protected void init() {
        super.init();
        this.addWidgets(this.pad);
    }

    public void shareLaunchPad() {
        if (this.pad == null) {
            return;
        }
        this.onClose();
        ChatScreen screen = new ChatScreen("/stellaris launchpads share \"" + this.pad.name() + "\" ");
        this.minecraft.setScreen((Screen)screen);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 256 || keyCode == 257) && this.nameBox.isFocused()) {
            this.nameBox.setFocused(false);
            return true;
        }
        if ((this.nameBox.isHovered() || this.nameBox.isFocused()) && keyCode == 69) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
    }

    private void addWidgets(@Nullable LaunchPad pad) {
        this.nameBox = new EditBox(this.font, this.leftPos + 50, this.topPos + 40, 59, 14, (Component)Component.translatable((String)"gui.stellaris.launchpad_creator.name"));
        this.whitelistBox = new EditBox(this.font, this.leftPos + 120, this.topPos + 38, 80, 20, (Component)Component.translatable((String)"gui.stellaris.launchpad_creator.name"));
        this.nameBox.setBordered(false);
        this.publicCheckbox = new CustomCheckBox(this.leftPos + 120, this.topPos + 38, 17, (Component)Component.literal((String)""), this.font, false).setTexture(GUISprites.INDUSTRIAL_CHECKBOX, GUISprites.INDUSTRIAL_CHECKBOX_SELECTED);
        this.saveButton = ((TexturedButton)((Object)new TexturedButton(this.leftPos + (this.imageWidth / 2 - 40), this.inventoryLabelY, 60, 20, (Component)Component.literal((String)"Create"), b -> this.onClose()).tex(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/antenna_button.png"), ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/antenna_button_hovered.png")))).showText(true);
        Object shareButton = ((TexturedButton)((Object)((TexturedButton)((Object)new TexturedButton(this.saveButton.getX() + this.saveButton.getWidth() + 5, this.saveButton.getY(), 20, 20, (Component)Component.literal((String)""), b -> this.shareLaunchPad()).tex(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/share_button.png"), ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/share_button_hovered.png")))).tooltip(Tooltip.create((Component)Component.literal((String)"Share Launch Pad"))))).showTooltip(false);
        this.addRenderableWidget((GuiEventListener)shareButton);
        if (pad != null) {
            this.nameBox.setValue(pad.name());
            this.whitelistBox.setValue(String.join((CharSequence)",", pad.whitelist()));
            this.publicCheckbox.setSelected(pad.isPublic());
            this.saveButton.setMessage((Component)Component.literal((String)"Save"));
        }
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        this.addRenderableWidget((GuiEventListener)this.publicCheckbox);
    }

    public void onClose() {
        this.saveLaunchPad();
        super.onClose();
    }

    private void saveLaunchPad() {
        if (this.nameBox.getValue().isEmpty() || this.nameBox.getValue().equals(" ")) {
            return;
        }
        boolean create = false;
        if (this.pad == null) {
            this.pad = new LaunchPad(LaunchPadUtils.getNextLaunchPadId(), Utils.blockPosToVec3(this.blockEntity.getBlockPos()), (ResourceKey<Level>)this.blockEntity.getLevel().dimension(), this.nameBox.getValue(), this.publicCheckbox.selected, ((AntennaMenu)this.menu).getPlayer().getDisplayName().getString(), List.of(this.whitelistBox.getValue().split(",")));
            create = true;
        } else {
            this.pad = new LaunchPad(this.pad.id(), this.pad.position(), this.pad.dimension(), this.nameBox.getValue(), this.publicCheckbox.selected, this.pad.owner(), List.of(this.whitelistBox.getValue().split(",")));
            NetworkManager.sendToServer((CustomPacketPayload)new LaunchPadsOperations(this.pad, "modify"));
        }
        this.blockEntity.setLaunchPad(this.pad, create);
    }
}

