/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxProvider;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.data.FluxDeviceConfigComponent;
import sonar.fluxnetworks.common.device.TileFluxDevice;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemFluxConfigurator
extends Item {
    public ItemFluxConfigurator(Item.Properties props) {
        super(props);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof TileFluxDevice) {
            TileFluxDevice device = (TileFluxDevice)blockEntity;
            if (!device.canPlayerAccess(player)) {
                player.displayClientMessage(FluxTranslate.ACCESS_DENIED, true);
                return InteractionResult.FAIL;
            }
            if (player.isShiftKeyDown()) {
                config = (FluxDeviceConfigComponent)device.collectComponents().get(FluxDataComponents.FLUX_CONFIG);
                if (config != null) {
                    stack.set(FluxDataComponents.FLUX_CONFIG, (Object)config);
                    player.displayClientMessage(FluxTranslate.CONFIG_COPIED, false);
                }
            } else {
                config = (FluxDeviceConfigComponent)stack.get(FluxDataComponents.FLUX_CONFIG);
                if (config != null) {
                    device.applyComponentsFromItemStack(stack);
                    player.displayClientMessage(FluxTranslate.CONFIG_PASTED, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        player.openMenu((MenuProvider)new Provider(stack), buf -> buf.writeBoolean(false));
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        FluxDeviceConfigComponent component = (FluxDeviceConfigComponent)stack.get(FluxDataComponents.FLUX_CONFIG);
        if (component != null) {
            FluxNetwork network = ClientCache.getNetwork(component.networkId());
            if (network.isValid()) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + FluxTranslate.NETWORK_FULL_NAME.get() + ": " + String.valueOf(ChatFormatting.RESET) + network.getNetworkName())));
            }
            if (component.limit().isPresent()) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + FluxTranslate.TRANSFER_LIMIT.get() + ": " + String.valueOf(ChatFormatting.RESET) + EnergyType.FE.getStorage(component.getLimit()))));
            }
            if (component.priority().isPresent()) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + FluxTranslate.PRIORITY.get() + ": " + String.valueOf(ChatFormatting.RESET) + component.getPriority())));
            }
        }
    }

    public static class Provider
    implements IFluxProvider {
        public final ItemStack mStack;

        public Provider(@Nonnull ItemStack stack) {
            this.mStack = stack;
        }

        @Override
        public int getNetworkID() {
            return ((FluxDeviceConfigComponent)this.mStack.getOrDefault(FluxDataComponents.FLUX_CONFIG, (Object)FluxDeviceConfigComponent.EMPTY)).networkId();
        }

        @Override
        public void onPlayerOpened(@Nonnull Player player) {
        }

        @Override
        public void onPlayerClosed(@Nonnull Player player) {
        }

        @Nullable
        public FluxMenu createMenu(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new FluxMenu(containerId, inventory, this);
        }
    }
}

