/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.common.connection.NetworkStatistics;
import sonar.fluxnetworks.common.connection.PhantomFluxDevice;
import sonar.fluxnetworks.common.data.FluxPlayerData;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.util.FluxUtils;

@ParametersAreNonnullByDefault
public class FluxNetwork {
    public static final FluxNetwork INVALID = new FluxNetwork();
    public static final int ANY = 0;
    public static final int PLUG = 1;
    public static final int POINT = 2;
    public static final int STORAGE = 3;
    public static final int CONTROLLER = 4;
    public static final int MAX_NETWORK_NAME_LENGTH = 24;
    public static final int MAX_PASSWORD_LENGTH = 16;
    public static final String NETWORK_NAME = "name";
    public static final String NETWORK_COLOR = "color";
    public static final String OWNER_UUID = "owner";
    public static final String SECURITY_LEVEL = "security";
    public static final String MEMBERS = "members";
    public static final String CONNECTIONS = "connections";
    int mID;
    String mName;
    int mColor;
    UUID mOwnerUUID;
    SecurityLevel mSecurityLevel;
    final NetworkStatistics mStatistics = new NetworkStatistics(this);
    final HashMap<UUID, NetworkMember> mMemberMap = new HashMap();
    final HashMap<GlobalPos, IFluxDevice> mConnectionMap = new HashMap();

    FluxNetwork() {
        this(-1, "", 0xB2B2B2, SecurityLevel.PUBLIC, Util.NIL_UUID);
    }

    FluxNetwork(int id, String name, int color, @Nonnull SecurityLevel security, @Nonnull Player owner) {
        this(id, name, color, security, owner.getUUID());
        this.mMemberMap.put(this.mOwnerUUID, NetworkMember.create(owner, AccessLevel.OWNER));
    }

    private FluxNetwork(int id, String name, int color, @Nonnull SecurityLevel security, @Nonnull UUID owner) {
        this.mID = id;
        this.mName = name;
        this.mColor = color;
        this.mSecurityLevel = security;
        this.mOwnerUUID = owner;
    }

    public final int getNetworkID() {
        return this.mID;
    }

    @Nonnull
    public final UUID getOwnerUUID() {
        return this.mOwnerUUID;
    }

    @Nonnull
    public final String getNetworkName() {
        return this.mName;
    }

    public boolean setNetworkName(@Nonnull String name) {
        if (!name.equals(this.mName) && !FluxUtils.isBadNetworkName(name)) {
            this.mName = name;
            return true;
        }
        return false;
    }

    public final int getNetworkColor() {
        return this.mColor;
    }

    public boolean setNetworkColor(int color) {
        if (this.mColor != (color &= 0xFFFFFF)) {
            this.mColor = color;
            return true;
        }
        return false;
    }

    @Nonnull
    public final SecurityLevel getSecurityLevel() {
        return this.mSecurityLevel;
    }

    public boolean setSecurityLevel(@Nonnull SecurityLevel level) {
        if (this.mSecurityLevel != level) {
            this.mSecurityLevel = level;
            return true;
        }
        return false;
    }

    @Nonnull
    public NetworkStatistics getStatistics() {
        return this.mStatistics;
    }

    @Nullable
    public NetworkMember getMemberByUUID(@Nonnull UUID uuid) {
        return this.mMemberMap.get(uuid);
    }

    @Nonnull
    public Collection<NetworkMember> getAllMembers() {
        return this.mMemberMap.values();
    }

    @Nullable
    public IFluxDevice getConnectionByPos(@Nonnull GlobalPos pos) {
        return this.mConnectionMap.get(pos);
    }

    @Nonnull
    public Collection<IFluxDevice> getAllConnections() {
        return this.mConnectionMap.values();
    }

    public void onEndServerTick() {
    }

    public void onDelete() {
        this.mMemberMap.clear();
        this.mConnectionMap.clear();
    }

    @Nonnull
    public AccessLevel getPlayerAccess(@Nonnull Player player) {
        UUID uuid = player.getUUID();
        if (this.mOwnerUUID.equals(uuid)) {
            return AccessLevel.OWNER;
        }
        NetworkMember member = this.getMemberByUUID(uuid);
        if (member != null) {
            return member.getAccessLevel();
        }
        return this.mSecurityLevel == SecurityLevel.PUBLIC ? AccessLevel.USER : AccessLevel.BLOCKED;
    }

    public final boolean canPlayerAccess(@Nonnull Player player) {
        return this.canPlayerAccess(player, "");
    }

    public boolean canPlayerAccess(@Nonnull Player player, @Nonnull String password) {
        return this.getPlayerAccess(player).canUse();
    }

    @Nonnull
    public List<TileFluxDevice> getLogicalDevices(int logic) {
        return Collections.emptyList();
    }

    public long getBufferLimiter() {
        return 0L;
    }

    public boolean enqueueConnectionAddition(@Nonnull TileFluxDevice device) {
        return true;
    }

    public void enqueueConnectionRemoval(@Nonnull TileFluxDevice device, boolean unload) {
    }

    public int changeMembership(Player player, UUID targetUUID, byte type) {
        throw new IllegalStateException();
    }

    public boolean isValid() {
        return false;
    }

    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        Collection<IFluxDevice> connections;
        CompoundTag subTag;
        CompoundTag subTag2;
        ListTag list;
        Collection<NetworkMember> members;
        if (type == 21 || type == 1) {
            tag.putInt("network_id", this.mID);
            tag.putString(NETWORK_NAME, this.mName);
            tag.putInt(NETWORK_COLOR, this.mColor);
            tag.putUUID(OWNER_UUID, this.mOwnerUUID);
            tag.putByte(SECURITY_LEVEL, this.mSecurityLevel.getId());
        }
        if (type == 1) {
            Collection<IFluxDevice> connections2;
            members = this.getAllMembers();
            if (!members.isEmpty()) {
                list = new ListTag();
                for (NetworkMember networkMember : members) {
                    CompoundTag subTag22 = new CompoundTag();
                    networkMember.writeNBT(subTag22);
                    list.add((Object)subTag22);
                }
                tag.put(MEMBERS, (Tag)list);
            }
            if (!(connections2 = this.getAllConnections()).isEmpty()) {
                ListTag list2 = new ListTag();
                for (IFluxDevice d : connections2) {
                    if (d.isChunkLoaded()) continue;
                    subTag2 = new CompoundTag();
                    d.writeCustomTag(subTag2, (byte)1);
                    list2.add((Object)subTag2);
                }
                tag.put(CONNECTIONS, (Tag)list2);
            }
        }
        if (type == 22) {
            members = this.getAllMembers();
            list = new ListTag();
            if (!members.isEmpty()) {
                for (NetworkMember networkMember : members) {
                    subTag = new CompoundTag();
                    networkMember.writeNBT(subTag);
                    list.add((Object)subTag);
                }
            }
            List players = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers();
            for (ServerPlayer p : players) {
                if (this.getMemberByUUID(p.getUUID()) != null) continue;
                subTag2 = new CompoundTag();
                NetworkMember.create((Player)p, FluxPlayerData.isPlayerSuperAdmin(p) ? AccessLevel.SUPER_ADMIN : AccessLevel.BLOCKED).writeNBT(subTag2);
                list.add((Object)subTag2);
            }
            tag.put(MEMBERS, (Tag)list);
        }
        if (type == 23 && !(connections = this.getAllConnections()).isEmpty()) {
            list = new ListTag();
            for (IFluxDevice iFluxDevice : connections) {
                subTag = new CompoundTag();
                iFluxDevice.writeCustomTag(subTag, (byte)20);
                list.add((Object)subTag);
            }
            tag.put(CONNECTIONS, (Tag)list);
        }
        if (type == 24) {
            this.mStatistics.writeNBT(tag);
        }
    }

    public void readCustomTag(@Nonnull CompoundTag tag, byte type) {
        NetworkMember m;
        CompoundTag c;
        int i;
        ListTag list;
        if (type == 21 || type == 1) {
            this.mID = tag.getInt("network_id");
            this.mName = tag.getString(NETWORK_NAME);
            this.mColor = tag.getInt(NETWORK_COLOR);
            this.mOwnerUUID = tag.getUUID(OWNER_UUID);
            this.mSecurityLevel = SecurityLevel.fromId(tag.getByte(SECURITY_LEVEL));
        }
        if (type == 1) {
            list = tag.getList(MEMBERS, 10);
            for (i = 0; i < list.size(); ++i) {
                c = list.getCompound(i);
                m = new NetworkMember(c);
                this.mMemberMap.put(m.getPlayerUUID(), m);
            }
            list = tag.getList(CONNECTIONS, 10);
            for (i = 0; i < list.size(); ++i) {
                c = list.getCompound(i);
                PhantomFluxDevice f = PhantomFluxDevice.make(c);
                this.mConnectionMap.put(f.getGlobalPos(), f);
            }
        }
        if (type == 22) {
            this.mMemberMap.clear();
            list = tag.getList(MEMBERS, 10);
            for (i = 0; i < list.size(); ++i) {
                c = list.getCompound(i);
                m = new NetworkMember(c);
                this.mMemberMap.put(m.getPlayerUUID(), m);
            }
        }
        if (type == 23) {
            this.mConnectionMap.clear();
            list = tag.getList(CONNECTIONS, 10);
            for (i = 0; i < list.size(); ++i) {
                c = list.getCompound(i);
                GlobalPos pos = FluxUtils.readGlobalPos(c);
                this.mConnectionMap.put(pos, PhantomFluxDevice.makeUpdated(pos, c));
            }
        }
        if (type == 24) {
            this.mStatistics.readNBT(tag);
        }
    }

    public String toString() {
        return "FluxNetwork{id=" + this.mID + ", name='" + this.mName + "', owner=" + String.valueOf(this.mOwnerUUID) + "}";
    }
}

